/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.inventory;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.inventory.AbstractInventory;
import fun.lewisdev.deluxehub.inventory.InventoryListener;
import fun.lewisdev.deluxehub.inventory.inventories.CustomGUI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class InventoryManager {
    private DeluxeHubPlugin plugin;
    private final Map<String, AbstractInventory> inventories = new ConcurrentHashMap<String, AbstractInventory>();

    public void onEnable(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
        this.loadCustomMenus();
        this.inventories.values().forEach(AbstractInventory::onEnable);
        plugin.getServer().getPluginManager().registerEvents(new InventoryListener(), plugin);
    }

    private void loadCustomMenus() {
        File directory = new File(this.plugin.getDataFolder(), "menus");
        this.createMenusDirectoryIfNeeded(directory);
        File[] yamlFiles = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (yamlFiles == null) {
            return;
        }
        for (File file : yamlFiles) {
            String name2 = file.getName().replace(".yml", "");
            if (this.inventories.containsKey(name2)) {
                this.plugin.getLogger().warning("Inventory with name '" + file.getName() + "' already exists, skipping duplicate..");
                continue;
            }
            try {
                CustomGUI customGUI = new CustomGUI(this.plugin, YamlConfiguration.loadConfiguration(file));
                this.inventories.put(name2, customGUI);
                this.plugin.getLogger().info("Loaded custom menu '" + name2 + "'.");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not load file '" + name2 + "' (YAML error).");
                e.printStackTrace();
            }
        }
    }

    private void createMenusDirectoryIfNeeded(File directory) {
        if (!directory.exists()) {
            directory.mkdir();
            File file = new File(directory, "serverselector.yml");
            if (!file.exists()) {
                try (InputStream inputStream = this.plugin.getResource("serverselector.yml");){
                    if (inputStream != null) {
                        Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        this.plugin.getLogger().warning("Resource 'serverselector.yml' not found.");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addInventory(String key, AbstractInventory inventory) {
        this.inventories.put(key, inventory);
    }

    public Map<String, AbstractInventory> getInventories() {
        return this.inventories;
    }

    public Optional<AbstractInventory> getInventory(String key) {
        return Optional.ofNullable(this.inventories.get(key));
    }

    public void onDisable() {
        this.inventories.values().forEach(abstractInventory -> {
            abstractInventory.getOpenInventories().forEach(uuid -> {
                Player player = Bukkit.getPlayer(uuid);
                if (player != null) {
                    player.closeInventory();
                }
            });
            abstractInventory.getOpenInventories().clear();
        });
        this.inventories.clear();
    }
}

