/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.libs.command.minecraft.util.commands;

import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.CommandContext;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.annotations.Command;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.annotations.CommandAlias;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.annotations.CommandPermissions;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.annotations.CommandScopes;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.annotations.NestedCommand;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandPermissionsException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandRegistrationException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.CommandUsageException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.MissingNestedCommandException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.ScopeMismatchException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.SuggestException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.UnhandledCommandException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.WrappedCommandException;
import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.injection.Injector;
import fun.lewisdev.deluxehub.libs.command.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Provider;

public abstract class CommandsManager<T> {
    protected static final Logger logger = Logger.getLogger(CommandsManager.class.getCanonicalName());
    protected Map<Method, Map<String, Method>> commands = new HashMap<Method, Map<String, Method>>();
    protected Map<Class, Object> instances = new HashMap<Class, Object>();
    protected Map<Method, Provider> providers = new HashMap<Method, Provider>();
    protected Map<String, String> descs = new HashMap<String, String>();
    protected Injector injector;
    protected Map<String, String> helpMessages = new HashMap<String, String>();

    public void register(Class<?> cls) {
        this.registerMethods(cls, null);
    }

    public List<Command> registerAndReturn(Class<?> cls) {
        return this.registerMethods(cls, null);
    }

    public List<Command> registerMethods(Class<?> cls, Method parent) {
        return this.registerMethods(cls, parent, null);
    }

    public <C> List<Command> registerMethods(Class<C> cls, @Nullable Method parent, @Nullable Provider<? extends C> provider) {
        try {
            return this.registerMethods0(cls, parent, provider);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CommandRegistrationException("Failed to register commands in class " + cls.getName(), e);
        }
    }

    private <C> List<Command> registerMethods0(Class<C> cls, Method parent, @Nullable Provider<? extends C> provider) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Map<Object, Object> map;
        ArrayList<Command> registered = new ArrayList<Command>();
        if (this.commands.containsKey(parent)) {
            map = this.commands.get(parent);
        } else {
            map = new HashMap();
            this.commands.put(parent, map);
        }
        for (Method method : cls.getMethods()) {
            if (!method.isAnnotationPresent(Command.class)) continue;
            if (!Void.TYPE.equals(method.getReturnType()) && !List.class.isAssignableFrom(method.getReturnType())) {
                throw new CommandRegistrationException("Command method " + method.getDeclaringClass().getName() + "#" + method.getName() + " must return either void or List<String>");
            }
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            Command cmd = method.getAnnotation(Command.class);
            for (String alias : cmd.aliases()) {
                map.put(alias, method);
            }
            if (!isStatic) {
                if (provider == null && this.injector != null && (provider = this.injector.getProviderOrNull(cls)) == null) {
                    Object instance = this.instances.get(cls);
                    if (instance == null) {
                        instance = this.injector.getInstance(cls);
                        this.instances.put(cls, instance);
                    }
                    Object finalInstance = instance;
                    provider = () -> finalInstance;
                }
                if (provider != null) {
                    this.providers.put(method, provider);
                } else {
                    String text = "Failed to get an instance/provider of " + cls.getName() + " for command method " + method.getDeclaringClass().getName() + "#" + method.getName();
                    text = this.injector == null ? text + " (no Injector is available to create it)" : text + " (the Injector returned null when asked for one)";
                    throw new CommandRegistrationException(text);
                }
            }
            if (parent == null) {
                String commandName = cmd.aliases()[0];
                String desc = cmd.desc();
                String usage = cmd.usage();
                if (usage.isEmpty()) {
                    this.descs.put(commandName, desc);
                } else {
                    this.descs.put(commandName, usage + " - " + desc);
                }
                String help = cmd.help();
                if (help.isEmpty()) {
                    help = desc;
                }
                CharSequence arguments = this.getArguments(cmd);
                for (String alias : cmd.aliases()) {
                    String helpMessage = "/" + alias + " " + arguments + "\n\n" + help;
                    String key = alias.replaceAll("/", "");
                    String previous = this.helpMessages.put(key, helpMessage);
                    if (previous == null || previous.replaceAll("^/[^ ]+ ", "").equals(helpMessage.replaceAll("^/[^ ]+ ", ""))) continue;
                    this.helpMessages.put(key, previous + "\n\n" + helpMessage);
                }
            }
            registered.add(cmd);
            if (!method.isAnnotationPresent(NestedCommand.class)) continue;
            NestedCommand nestedCmd = method.getAnnotation(NestedCommand.class);
            for (Class<?> nestedCls : nestedCmd.value()) {
                this.registerMethods(nestedCls, method);
            }
        }
        if (cls.getSuperclass() != null) {
            this.registerMethods0(cls.getSuperclass(), parent, provider);
        }
        return registered;
    }

    public boolean hasCommand(String command) {
        return this.commands.get(null).containsKey(command.toLowerCase());
    }

    public Map<String, String> getCommands() {
        return this.descs;
    }

    public Map<Method, Map<String, Method>> getMethods() {
        return this.commands;
    }

    public Map<String, String> getHelpMessages() {
        return this.helpMessages;
    }

    protected String getUsage(String[] args, int level, Command cmd) {
        StringBuilder command = new StringBuilder();
        command.append('/');
        for (int i = 0; i <= level; ++i) {
            command.append(args[i]);
            command.append(' ');
        }
        command.append(this.getArguments(cmd));
        String help = cmd.help();
        if (!help.isEmpty()) {
            command.append("\n\n");
            command.append(help);
        }
        return command.toString();
    }

    protected CharSequence getArguments(Command cmd) {
        String flagString;
        String flags = cmd.flags();
        StringBuilder command2 = new StringBuilder();
        if (!flags.isEmpty() && !(flagString = flags.replaceAll(".:", "")).isEmpty()) {
            command2.append("[-");
            for (int i = 0; i < flagString.length(); ++i) {
                command2.append(flagString.charAt(i));
            }
            command2.append("] ");
        }
        command2.append(cmd.usage());
        return command2;
    }

    protected String getNestedUsage(String[] args, int level, Method method, T player) throws CommandException {
        StringBuilder command = new StringBuilder();
        command.append("/");
        for (int i = 0; i <= level; ++i) {
            command.append(args[i]).append(" ");
        }
        Map<String, Method> map = this.commands.get(method);
        boolean found = false;
        command.append("<");
        HashSet<String> allowedCommands = new HashSet<String>();
        for (Map.Entry<String, Method> entry : map.entrySet()) {
            Method childMethod = entry.getValue();
            found = true;
            if (!this.hasPermission(childMethod, player)) continue;
            Command childCmd = childMethod.getAnnotation(Command.class);
            allowedCommands.add(childCmd.aliases()[0]);
        }
        if (!allowedCommands.isEmpty()) {
            command.append(StringUtil.joinString(allowedCommands, "|", 0));
        } else if (!found) {
            command.append("?");
        } else {
            throw new CommandPermissionsException();
        }
        command.append(">");
        return command.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean supportsCompletion(Method method) {
        if (List.class.isAssignableFrom(method.getReturnType())) return true;
        if (!Stream.of(method.getExceptionTypes()).anyMatch(SuggestException.class::isAssignableFrom)) return false;
        return true;
    }

    public void execute(String cmd, String[] args, T player, Object ... methodArgs) throws CommandException {
        this.executeMethod(false, cmd, args, player, methodArgs);
    }

    @Nullable
    public List<String> complete(String cmd, String[] args, T player, Object ... methodArgs) {
        try {
            return this.executeMethod(true, cmd, args, player, methodArgs);
        }
        catch (CommandException e) {
            return Collections.emptyList();
        }
    }

    private List<String> executeMethod(boolean completing, String cmd, String[] args, T player, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = cmd;
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        return this.executeMethod(null, completing, newArgs, player, newMethodArgs, 0);
    }

    private List<String> executeMethod(Method parent, boolean completing, String[] args, T player, Object[] methodArgs, int level) throws CommandException {
        String cmdName = args[level];
        String cmdNameLower = cmdName.toLowerCase();
        int argsCount = args.length - 1 - level;
        Map<String, Method> map = this.commands.get(parent);
        if (completing && argsCount == 0) {
            ArrayList<String> children = new ArrayList<String>();
            for (Map.Entry<String, Method> entry : map.entrySet()) {
                String child = entry.getKey();
                if (!child.toLowerCase().startsWith(cmdNameLower) || !this.hasPermission(entry.getValue(), player)) continue;
                children.add(child);
            }
            return children;
        }
        Method method = map.get(cmdNameLower);
        if (method == null) {
            if (parent == null) {
                throw new UnhandledCommandException();
            }
            throw new MissingNestedCommandException("Unknown command: " + cmdName, this.getNestedUsage(args, level - 1, parent, player));
        }
        if (!this.scopeMatches(method, player)) {
            CommandScopes scopes = method.getAnnotation(CommandScopes.class);
            throw new ScopeMismatchException("CommandSender scope mismatch.", scopes.value());
        }
        if (!this.hasPermission(method, player)) {
            throw new CommandPermissionsException();
        }
        NestedCommand nestedAnnot = method.getAnnotation(NestedCommand.class);
        if (!(nestedAnnot == null || argsCount <= 0 && nestedAnnot.executeBody())) {
            if (argsCount == 0) {
                throw new MissingNestedCommandException("Sub-command required.", this.getNestedUsage(args, level, method, player));
            }
            return this.executeMethod(method, completing, args, player, methodArgs, level + 1);
        }
        if (method.isAnnotationPresent(CommandAlias.class)) {
            CommandAlias aCmd = method.getAnnotation(CommandAlias.class);
            return this.executeMethod(parent, completing, aCmd.value(), player, methodArgs, level);
        }
        Command cmd = method.getAnnotation(Command.class);
        if (completing && !CommandsManager.supportsCompletion(method)) {
            return null;
        }
        String[] newArgs = new String[args.length - level];
        System.arraycopy(args, level, newArgs, 0, args.length - level);
        HashSet<Character> valueFlags = new HashSet<Character>();
        char[] flags = cmd.flags().toCharArray();
        HashSet<Character> newFlags = new HashSet<Character>();
        for (int i = 0; i < flags.length; ++i) {
            if (flags.length > i + 1 && flags[i + 1] == ':') {
                valueFlags.add(Character.valueOf(flags[i]));
                ++i;
            }
            newFlags.add(Character.valueOf(flags[i]));
        }
        CommandContext context = new CommandContext(newArgs, valueFlags, completing);
        if (!completing) {
            if (context.argsLength() < cmd.min()) {
                throw new CommandUsageException("Too few arguments.", this.getUsage(args, level, cmd));
            }
            if (cmd.max() != -1 && context.argsLength() > cmd.max()) {
                throw new CommandUsageException("Too many arguments.", this.getUsage(args, level, cmd));
            }
            if (!cmd.anyFlags()) {
                for (char flag : context.getFlags()) {
                    if (newFlags.contains(Character.valueOf(flag))) continue;
                    throw new CommandUsageException("Unknown flag: " + flag, this.getUsage(args, level, cmd));
                }
            }
        }
        methodArgs[0] = context;
        Provider provider = this.providers.get(method);
        Object instance = provider == null ? null : provider.get();
        try {
            List<String> completions = (List<String>)method.invoke(instance, methodArgs);
            return completions != null ? completions : Collections.emptyList();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
            return Collections.emptyList();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SuggestException && context.isSuggesting()) {
                return ((SuggestException)e.getCause()).suggestions();
            }
            if (e.getCause() instanceof CommandException) {
                if (e.getCause() instanceof CommandUsageException) {
                    ((CommandUsageException)e.getCause()).offerUsage(this.getUsage(args, argsCount, method.getAnnotation(Command.class)));
                }
                throw (CommandException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new WrappedCommandException(e.getCause());
        }
    }

    protected boolean hasPermission(Method method, T player) {
        CommandPermissions perms = method.getAnnotation(CommandPermissions.class);
        if (perms == null) {
            return true;
        }
        for (String perm : perms.value()) {
            if (!this.hasPermission(player, perm)) continue;
            return true;
        }
        return false;
    }

    protected boolean scopeMatches(Method method, T player) {
        CommandScopes scopes = method.getAnnotation(CommandScopes.class);
        if (scopes == null) {
            return true;
        }
        for (String scope : scopes.value()) {
            if (!this.scopeMatches(player, scope)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean hasPermission(T var1, String var2);

    public abstract boolean scopeMatches(T var1, String var2);

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }
}

