/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.libs.command.minecraft.util.commands;

import fun.lewisdev.deluxehub.libs.command.minecraft.util.commands.exceptions.SuggestException;
import fun.lewisdev.deluxehub.libs.command.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;

public class SuggestionContext {
    private final String context;
    private final String prefix;
    private final int index;
    @Nullable
    private final Character flag;

    public SuggestionContext(String context, String prefix, int index, @Nullable Character flag) {
        this.context = context;
        this.prefix = prefix;
        this.index = index;
        this.flag = flag;
    }

    public String getContext() {
        return this.context;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isArgument() {
        return this.flag == null;
    }

    public boolean isFlag() {
        return this.flag != null;
    }

    public int getIndex() {
        return this.index;
    }

    @Nullable
    public Character getFlag() {
        return this.flag;
    }

    public boolean isArgument(int index) {
        return this.isArgument() && this.getIndex() == index;
    }

    public boolean isFlag(char flag) {
        return this.isFlag() && this.getFlag().charValue() == flag;
    }

    public List<String> complete(Iterable<String> choices) {
        return StringUtil.complete(this.getPrefix(), choices);
    }

    public void suggest(Iterable<String> choices) throws SuggestException {
        throw new SuggestException(this.complete(choices));
    }

    public void suggestArgument(int index, Iterable<String> choices) throws SuggestException {
        if (this.isArgument(index)) {
            this.suggest(choices);
        }
    }

    public void suggestFlag(char flag, Iterable<String> choices) throws SuggestException {
        if (this.isFlag(flag)) {
            this.suggest(choices);
        }
    }

    public String toString() {
        return this.isArgument() ? "argument " + this.getIndex() : "flag -" + this.getFlag();
    }
}

