/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.cooldown.CooldownManager;
import fun.lewisdev.deluxehub.cooldown.CooldownType;
import fun.lewisdev.deluxehub.module.ModuleType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public abstract class Module
implements Listener {
    private final DeluxeHubPlugin plugin;
    private final ModuleType moduleType;
    private List<String> disabledWorlds;
    private final CooldownManager cooldownManager;

    public Module(DeluxeHubPlugin plugin, ModuleType type) {
        this.plugin = plugin;
        this.moduleType = type;
        this.cooldownManager = plugin.getCooldownManager();
        this.disabledWorlds = new ArrayList<String>();
    }

    public void setDisabledWorlds(List<String> disabledWorlds) {
        this.disabledWorlds = disabledWorlds;
    }

    public DeluxeHubPlugin getPlugin() {
        return this.plugin;
    }

    public boolean inDisabledWorld(Location location) {
        return this.disabledWorlds.contains(location.getWorld().getName());
    }

    public boolean inDisabledWorld(World world) {
        return this.disabledWorlds.contains(world.getName());
    }

    public boolean tryCooldown(UUID uuid, CooldownType type, long delay) {
        return this.cooldownManager.tryCooldown(uuid, type, delay);
    }

    public String getCooldown(UUID uuid, CooldownType type) {
        return String.valueOf(this.cooldownManager.getCooldown(uuid, type) / 1000L);
    }

    public FileConfiguration getConfig(ConfigType type) {
        return this.getPlugin().getConfigManager().getFile(type).getConfig();
    }

    public void executeActions(Player player, List<String> actions) {
        this.getPlugin().getActionManager().executeActions(player, actions);
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public abstract void onEnable();

    public abstract void onDisable();
}

