/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.libs.xseries.reflection.XReflection;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import fun.lewisdev.deluxehub.module.modules.chat.AntiSwear;
import fun.lewisdev.deluxehub.module.modules.chat.AutoBroadcast;
import fun.lewisdev.deluxehub.module.modules.chat.ChatCommandBlock;
import fun.lewisdev.deluxehub.module.modules.chat.ChatLock;
import fun.lewisdev.deluxehub.module.modules.chat.CustomCommands;
import fun.lewisdev.deluxehub.module.modules.hologram.HologramManager;
import fun.lewisdev.deluxehub.module.modules.hotbar.HotbarManager;
import fun.lewisdev.deluxehub.module.modules.player.DoubleJump;
import fun.lewisdev.deluxehub.module.modules.player.PlayerListener;
import fun.lewisdev.deluxehub.module.modules.player.PlayerOffHandSwap;
import fun.lewisdev.deluxehub.module.modules.player.PlayerVanish;
import fun.lewisdev.deluxehub.module.modules.visual.scoreboard.ScoreboardManager;
import fun.lewisdev.deluxehub.module.modules.visual.tablist.TablistManager;
import fun.lewisdev.deluxehub.module.modules.world.AntiWorldDownloader;
import fun.lewisdev.deluxehub.module.modules.world.Launchpad;
import fun.lewisdev.deluxehub.module.modules.world.LobbySpawn;
import fun.lewisdev.deluxehub.module.modules.world.WorldProtect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.generator.WorldInfo;

public class ModuleManager {
    private DeluxeHubPlugin plugin;
    private List<String> disabledWorlds;
    private final Map<ModuleType, Module> modules = new HashMap<ModuleType, Module>();

    public void loadModules(DeluxeHubPlugin plugin) {
        this.plugin = plugin;
        if (!this.modules.isEmpty()) {
            this.unloadModules();
        }
        FileConfiguration config = plugin.getConfigManager().getFile(ConfigType.SETTINGS).getConfig();
        this.disabledWorlds = config.getStringList("disabled-worlds.worlds");
        if (config.getBoolean("disabled-worlds.invert")) {
            this.disabledWorlds = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
            for (String world : config.getStringList("disabled-worlds.worlds")) {
                this.disabledWorlds.remove(world);
            }
        }
        this.registerModule(new AntiWorldDownloader(plugin), "anti_wdl.enabled");
        this.registerModule(new DoubleJump(plugin), "double_jump.enabled");
        this.registerModule(new Launchpad(plugin), "launchpad.enabled");
        this.registerModule(new ScoreboardManager(plugin), "scoreboard.enabled");
        this.registerModule(new TablistManager(plugin), "tablist.enabled");
        this.registerModule(new AutoBroadcast(plugin), "announcements.enabled");
        this.registerModule(new AntiSwear(plugin), "anti_swear.enabled");
        this.registerModule(new ChatCommandBlock(plugin), "command_block.enabled");
        this.registerModule(new ChatLock(plugin));
        this.registerModule(new CustomCommands(plugin));
        this.registerModule(new PlayerListener(plugin));
        this.registerModule(new HotbarManager(plugin));
        this.registerModule(new WorldProtect(plugin));
        this.registerModule(new LobbySpawn(plugin));
        this.registerModule(new PlayerVanish(plugin));
        this.registerModule(new HologramManager(plugin));
        if (XReflection.supports(9)) {
            this.registerModule(new PlayerOffHandSwap(plugin), "world_settings.disable_off_hand_swap");
        }
        for (Module module : this.modules.values()) {
            try {
                module.setDisabledWorlds(this.disabledWorlds);
                module.onEnable();
            }
            catch (Exception e) {
                e.printStackTrace();
                plugin.getLogger().severe("============= DELUXEHUB MODULE LOAD ERROR =============");
                plugin.getLogger().severe("There was an error loading the " + String.valueOf((Object)module.getModuleType()) + " module");
                plugin.getLogger().severe("The plugin will now disable..");
                plugin.getLogger().severe("============= DELUXEHUB MODULE LOAD ERROR =============");
                plugin.getServer().getPluginManager().disablePlugin(plugin);
                break;
            }
        }
        plugin.getLogger().info("Loaded " + this.modules.size() + " plugin modules.");
    }

    public void unloadModules() {
        for (Module module : this.modules.values()) {
            try {
                HandlerList.unregisterAll(module);
                module.onDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.plugin.getLogger().severe("There was an error unloading the " + module.getModuleType().toString() + " module.");
            }
        }
        this.modules.clear();
    }

    public Module getModule(ModuleType type) {
        return this.modules.get((Object)type);
    }

    public void registerModule(Module module) {
        this.registerModule(module, null);
    }

    public void registerModule(Module module, String isEnabledPath) {
        DeluxeHubPlugin plugin = module.getPlugin();
        if (isEnabledPath != null && !plugin.getConfigManager().getFile(ConfigType.SETTINGS).getConfig().getBoolean(isEnabledPath, false)) {
            return;
        }
        plugin.getServer().getPluginManager().registerEvents(module, plugin);
        this.modules.put(module.getModuleType(), module);
    }

    public boolean isEnabled(ModuleType type) {
        return this.modules.containsKey((Object)type);
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }
}

