/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.hotbar;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import fun.lewisdev.deluxehub.module.modules.hotbar.HotbarItem;
import fun.lewisdev.deluxehub.module.modules.hotbar.items.CustomItem;
import fun.lewisdev.deluxehub.module.modules.hotbar.items.PlayerHider;
import fun.lewisdev.deluxehub.utility.ItemStackBuilder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HotbarManager
extends Module {
    private List<HotbarItem> hotbarItems;

    public HotbarManager(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.HOTBAR_ITEMS);
    }

    @Override
    public void onEnable() {
        this.hotbarItems = new ArrayList<HotbarItem>();
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        if (config.getBoolean("custom_join_items.enabled")) {
            for (String entry : config.getConfigurationSection("custom_join_items.items").getKeys(false)) {
                ItemStack item = ItemStackBuilder.getItemStack(config.getConfigurationSection("custom_join_items.items." + entry)).build();
                CustomItem customItem = new CustomItem(this, item, config.getInt("custom_join_items.items." + entry + ".slot"), entry);
                if (config.contains("custom_join_items.items." + entry + ".permission")) {
                    customItem.setPermission(config.getString("custom_join_items.items." + entry + ".permission"));
                }
                customItem.setConfigurationSection(config.getConfigurationSection("custom_join_items.items." + entry));
                customItem.setAllowMovement(config.getBoolean("custom_join_items.disable_inventory_movement"));
                this.registerHotbarItem(customItem);
            }
        }
        if (config.getBoolean("player_hider.enabled")) {
            ItemStack item = ItemStackBuilder.getItemStack(config.getConfigurationSection("player_hider.not_hidden")).build();
            PlayerHider playerHider = new PlayerHider(this, item, config.getInt("player_hider.slot"), "PLAYER_HIDER");
            playerHider.setAllowMovement(config.getBoolean("player_hider.disable_inventory_movement"));
            this.registerHotbarItem(playerHider);
        }
        this.giveItems();
    }

    @Override
    public void onDisable() {
        this.removeItems();
    }

    public List<HotbarItem> getHotbarItems() {
        return this.hotbarItems;
    }

    public void registerHotbarItem(HotbarItem hotbarItem) {
        this.getPlugin().getServer().getPluginManager().registerEvents(hotbarItem, this.getPlugin());
        this.hotbarItems.add(hotbarItem);
    }

    private void giveItems() {
        Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(player -> this.hotbarItems.forEach(hotbarItem -> hotbarItem.giveItem((Player)player)));
    }

    private void removeItems() {
        Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(player -> this.hotbarItems.forEach(hotbarItem -> hotbarItem.removeItem((Player)player)));
    }
}

