/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.hotbar.items;

import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.config.Messages;
import fun.lewisdev.deluxehub.cooldown.CooldownType;
import fun.lewisdev.deluxehub.libs.nbt.NBTItem;
import fun.lewisdev.deluxehub.module.modules.hotbar.HotbarItem;
import fun.lewisdev.deluxehub.module.modules.hotbar.HotbarManager;
import fun.lewisdev.deluxehub.utility.ItemStackBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerHider
extends HotbarItem {
    private int cooldown;
    private ItemStack hiddenItem;
    private List<UUID> hidden = new ArrayList<UUID>();

    public PlayerHider(HotbarManager hotbarManager, ItemStack item, int slot, String key) {
        super(hotbarManager, item, slot, key);
        FileConfiguration config = this.getHotbarManager().getConfig(ConfigType.SETTINGS);
        NBTItem nbtItem = new NBTItem(ItemStackBuilder.getItemStack(config.getConfigurationSection("player_hider.hidden")).build());
        nbtItem.setString("hotbarItem", key);
        this.hiddenItem = nbtItem.getItem();
        this.cooldown = config.getInt("player_hider.cooldown");
    }

    @Override
    protected void onInteract(Player player) {
        if (!this.getHotbarManager().tryCooldown(player.getUniqueId(), CooldownType.PLAYER_HIDER, this.cooldown)) {
            Messages.COOLDOWN_ACTIVE.send(player, "%time%", this.getHotbarManager().getCooldown(player.getUniqueId(), CooldownType.PLAYER_HIDER));
            return;
        }
        if (!this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
                player.hidePlayer(player2);
            }
            this.hidden.add(player.getUniqueId());
            Messages.PLAYER_HIDER_HIDDEN.send(player, new Object[0]);
            player.getInventory().setItem(this.getSlot(), this.hiddenItem);
        } else {
            for (Player player3 : Bukkit.getServer().getOnlinePlayers()) {
                player.showPlayer(player3);
            }
            this.hidden.remove(player.getUniqueId());
            Messages.PLAYER_HIDER_SHOWN.send(player, new Object[0]);
            player.getInventory().setItem(this.getSlot(), this.getItem());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getServer().getOnlinePlayers()) {
                player.showPlayer(player2);
            }
        }
        this.hidden.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.hidden.forEach(uuid -> Bukkit.getPlayer(uuid).hidePlayer(player));
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.getHotbarManager().inDisabledWorld(player.getLocation()) && this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                player.showPlayer(player2);
            }
            this.hidden.remove(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawnEvent(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.hidden.contains(player.getUniqueId())) {
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                player.showPlayer(player2);
            }
            this.hidden.remove(player.getUniqueId());
        }
    }
}

