/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.player;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.Permissions;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.config.Messages;
import fun.lewisdev.deluxehub.cooldown.CooldownType;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import java.util.List;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;

public class DoubleJump
extends Module {
    private long cooldownDelay;
    private double launch;
    private double launchY;
    private List<String> actions;

    public DoubleJump(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.DOUBLE_JUMP);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.cooldownDelay = config.getLong("double_jump.cooldown", 0L);
        this.launch = config.getDouble("double_jump.launch_power", 1.3);
        this.launchY = config.getDouble("double_jump.launch_power_y", 1.2);
        this.actions = config.getStringList("double_jump.actions");
        if (this.launch > 4.0) {
            this.launch = 4.0;
        }
        if (this.launchY > 4.0) {
            this.launchY = 4.0;
        }
    }

    @Override
    public void onDisable() {
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission(Permissions.DOUBLE_JUMP_BYPASS.getPermission())) {
            return;
        }
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (!event.isFlying()) {
            return;
        }
        if (!player.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        UUID uuid = player.getUniqueId();
        if (!this.tryCooldown(uuid, CooldownType.DOUBLE_JUMP, this.cooldownDelay)) {
            Messages.DOUBLE_JUMP_COOLDOWN.send(player, "%time%", this.getCooldown(uuid, CooldownType.DOUBLE_JUMP));
            return;
        }
        player.setVelocity(player.getLocation().getDirection().multiply(this.launch).setY(this.launchY));
        this.executeActions(player, this.actions);
        player.setAllowFlight(false);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR && !this.inDisabledWorld(player.getLocation())) {
            player.getPlayer().setAllowFlight(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            player.getPlayer().setAllowFlight(true);
        }
    }
}

