/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.player;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.Messages;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerVanish
extends Module {
    private List<UUID> vanished;
    private final DeluxeHubPlugin plugin;

    public PlayerVanish(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.VANISH);
        this.plugin = plugin;
    }

    @Override
    public void onEnable() {
        this.vanished = new ArrayList<UUID>();
    }

    @Override
    public void onDisable() {
        this.vanished.clear();
    }

    public void toggleVanish(Player player) {
        if (this.isVanished(player)) {
            this.vanished.remove(player.getUniqueId());
            Bukkit.getOnlinePlayers().forEach(pl -> pl.showPlayer(this.plugin, player));
            Messages.VANISH_DISABLE.send(player, new Object[0]);
            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        } else {
            this.vanished.add(player.getUniqueId());
            Bukkit.getOnlinePlayers().forEach(pl -> pl.hidePlayer(this.plugin, player));
            Messages.VANISH_ENABLE.send(player, new Object[0]);
            player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 1000000, 1));
        }
    }

    public boolean isVanished(Player player) {
        return this.vanished.contains(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.vanished.forEach(hidden -> event.getPlayer().hidePlayer(Bukkit.getPlayer(hidden)));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        this.vanished.remove(player.getUniqueId());
    }
}

