/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.visual.scoreboard;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import fun.lewisdev.deluxehub.module.modules.visual.scoreboard.ScoreHelper;
import fun.lewisdev.deluxehub.module.modules.visual.scoreboard.ScoreUpdateTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ScoreboardManager
extends Module {
    private int scoreTask;
    private Map<UUID, ScoreHelper> players;
    private long joinDelay;
    private long worldDelay;
    private String title;
    private List<String> lines;

    public ScoreboardManager(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.SCOREBOARD);
    }

    @Override
    public void onEnable() {
        this.players = new HashMap<UUID, ScoreHelper>();
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.title = config.getString("scoreboard.title");
        this.lines = config.getStringList("scoreboard.lines");
        this.joinDelay = config.getLong("scoreboard.display_delay.server_enter", 0L);
        this.worldDelay = config.getLong("scoreboard.display_delay.world_change", 0L);
        if (config.getBoolean("scoreboard.refresh.enabled")) {
            this.scoreTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), new ScoreUpdateTask(this), 0L, config.getLong("scoreboard.refresh.rate"));
        }
        this.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(this::createScoreboard), 20L);
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.scoreTask);
        Bukkit.getOnlinePlayers().forEach(this::removeScoreboard);
    }

    public void createScoreboard(Player player) {
        this.players.put(player.getUniqueId(), this.updateScoreboard(player.getUniqueId()));
    }

    public ScoreHelper updateScoreboard(UUID uuid) {
        Player player = Bukkit.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        int lines = this.lines.size();
        ScoreHelper helper = this.players.get(player.getUniqueId());
        if (helper == null) {
            helper = new ScoreHelper(player);
        }
        helper.setTitle(this.title);
        for (String text : this.lines) {
            helper.setSlot(lines, text);
            --lines;
        }
        return helper;
    }

    public void removeScoreboard(Player player) {
        if (this.players.containsKey(player.getUniqueId())) {
            this.players.remove(player.getUniqueId());
            player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        }
    }

    public boolean hasScore(UUID uuid) {
        return this.players.containsKey(uuid);
    }

    public Collection<UUID> getPlayers() {
        return this.players.keySet();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.inDisabledWorld(player.getLocation()) && !this.hasScore(player.getUniqueId())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> this.createScoreboard(player), this.joinDelay);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.removeScoreboard(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().getWorld().getName().equals(event.getTo().getWorld().getName())) {
            return;
        }
        if (this.inDisabledWorld(event.getTo().getWorld()) && this.players.containsKey(player.getUniqueId())) {
            this.removeScoreboard(player);
        } else if (!this.players.containsKey(player.getUniqueId())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> this.createScoreboard(player), this.worldDelay);
        }
    }
}

