/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.module.modules.world;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.config.ConfigType;
import fun.lewisdev.deluxehub.module.Module;
import fun.lewisdev.deluxehub.module.ModuleType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class LobbySpawn
extends Module {
    private boolean spawnJoin;
    private Location location = null;
    private final DeluxeHubPlugin plugin;

    public LobbySpawn(DeluxeHubPlugin plugin) {
        super(plugin, ModuleType.LOBBY);
        this.plugin = plugin;
    }

    @Override
    public void onEnable() {
        Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> {
            FileConfiguration config = this.getConfig(ConfigType.DATA);
            if (config.contains("spawn")) {
                this.location = (Location)config.get("spawn");
            }
        });
        this.spawnJoin = this.getConfig(ConfigType.SETTINGS).getBoolean("join_settings.spawn_join", false);
    }

    @Override
    public void onDisable() {
        this.plugin.getConfigManager().saveFiles();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.spawnJoin && this.location != null) {
            player.teleport(this.location);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.location != null && !this.inDisabledWorld(player.getLocation())) {
            event.setRespawnLocation(this.location);
        }
    }
}

