/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.utility;

import fun.lewisdev.deluxehub.Permissions;
import fun.lewisdev.deluxehub.libs.library.utils.ColorUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final String localPluginVersion;
    private String spigotPluginVersion;
    private static final int ID = 49425;
    private static final Permission UPDATE_PERM = new Permission(Permissions.UPDATE_NOTIFICATION.getPermission(), PermissionDefault.TRUE);
    private static final long CHECK_INTERVAL = 12000L;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.localPluginVersion = plugin.getDescription().getVersion();
    }

    public void checkForUpdate() {
        new BukkitRunnable(){

            @Override
            public void run() {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)UpdateChecker.this.plugin, () -> {
                    try {
                        HttpsURLConnection connection = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=49425").openConnection();
                        connection.setRequestMethod("GET");
                        UpdateChecker.this.spigotPluginVersion = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.cancel();
                        return;
                    }
                    if (UpdateChecker.this.localPluginVersion.equals(UpdateChecker.this.spigotPluginVersion)) {
                        return;
                    }
                    UpdateChecker.this.plugin.getLogger().info("An update for DeluxeHub (v%VERSION%) is available at:".replace("%VERSION%", UpdateChecker.this.spigotPluginVersion));
                    UpdateChecker.this.plugin.getLogger().info("https://www.spigotmc.org/resources/49425");
                    Bukkit.getScheduler().runTask((Plugin)UpdateChecker.this.plugin, () -> Bukkit.getPluginManager().registerEvents(new Listener(){

                        @EventHandler(priority=EventPriority.MONITOR)
                        public void onPlayerJoin(PlayerJoinEvent event) {
                            Player player = event.getPlayer();
                            if (!player.hasPermission(UPDATE_PERM)) {
                                return;
                            }
                            player.sendMessage(ColorUtil.color("&7An update (v%VERSION%) for DeluxeHub is available at:".replace("%VERSION%", UpdateChecker.this.spigotPluginVersion)));
                            player.sendMessage(ColorUtil.color("&6https://www.spigotmc.org/resources/49425"));
                        }
                    }, UpdateChecker.this.plugin));
                    this.cancel();
                });
            }
        }.runTaskTimer(this.plugin, 0L, 12000L);
    }
}

