/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.utility.reflection;

import fun.lewisdev.deluxehub.DeluxeHubPlugin;
import fun.lewisdev.deluxehub.utility.reflection.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBar {
    private static final JavaPlugin PLUGIN = JavaPlugin.getProvidingPlugin(DeluxeHubPlugin.class);
    private static final MethodHandle CHAT_COMPONENT_TEXT;
    private static final MethodHandle PACKET;
    private static final Object CHAT_MESSAGE_TYPE;

    public static void sendActionBar(Player player, String message) {
        Objects.requireNonNull(player, "Cannot send action bar to null player");
        Object packet = null;
        try {
            Object component = CHAT_COMPONENT_TEXT.invoke(message);
            packet = PACKET.invoke(component, CHAT_MESSAGE_TYPE);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ReflectionUtils.sendPacket(player, packet);
    }

    public static void sendAllActionBar(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.sendActionBar(player, message);
        }
    }

    public static void sendActionBarWhile(final Player player, final String message, final Callable<Boolean> callable) {
        new BukkitRunnable(){

            @Override
            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ActionBar.sendActionBar(player, message);
            }
        }.runTaskTimerAsynchronously(PLUGIN, 0L, 40L);
    }

    public static void sendActionBarWhile(final Player player, final Callable<String> message, final Callable<Boolean> callable) {
        new BukkitRunnable(){

            @Override
            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                    ActionBar.sendActionBar(player, (String)message.call());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.runTaskTimerAsynchronously(PLUGIN, 0L, 40L);
    }

    public static void sendActionBar(final Player player, final String message, final long duration) {
        if (duration < 1L) {
            return;
        }
        new BukkitRunnable(){
            long repeater;
            {
                this.repeater = duration;
            }

            @Override
            public void run() {
                ActionBar.sendActionBar(player, message);
                this.repeater -= 40L;
                if (this.repeater - 40L < -20L) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(PLUGIN, 0L, 40L);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> packetPlayOutChatClass = ReflectionUtils.getNMSClass("PacketPlayOutChat");
        Class<?> iChatBaseComponentClass = ReflectionUtils.getNMSClass("IChatBaseComponent");
        MethodHandle packet = null;
        MethodHandle chatComp = null;
        Byte chatMsgType = null;
        try {
            Class<?> chatMessageTypeClass = Class.forName("net.minecraft.server." + ReflectionUtils.VERSION + ".ChatMessageType");
            for (Object obj : chatMessageTypeClass.getEnumConstants()) {
                if (!obj.toString().equals("GAME_INFO")) continue;
                chatMsgType = obj;
                break;
            }
            Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("ChatComponentText");
            chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
            packet = lookup.findConstructor(packetPlayOutChatClass, MethodType.methodType(Void.TYPE, iChatBaseComponentClass, chatMessageTypeClass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
            try {
                chatMsgType = 2;
                Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("ChatComponentText");
                chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
                packet = lookup.findConstructor(packetPlayOutChatClass, MethodType.methodType(Void.TYPE, iChatBaseComponentClass, Byte.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        CHAT_MESSAGE_TYPE = chatMsgType;
        CHAT_COMPONENT_TEXT = chatComp;
        PACKET = packet;
    }
}

