/*
 * Decompiled with CFR 0.152.
 */
package fun.lewisdev.deluxehub.utility.reflection;

import fun.lewisdev.deluxehub.utility.reflection.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import org.bukkit.entity.Player;

public class Titles {
    private static final Object TIMES;
    private static final Object TITLE;
    private static final Object SUBTITLE;
    private static final Object CLEAR;
    private static final MethodHandle PACKET;
    private static final MethodHandle CHAT_COMPONENT_TEXT;

    public static void sendTitle(Player player, int fadeIn, int stay, int fadeOut, String title, String subtitle) {
        Objects.requireNonNull(player, "Cannot send title to null player");
        if (title == null && subtitle == null) {
            return;
        }
        try {
            Object timesPacket = PACKET.invoke(TIMES, CHAT_COMPONENT_TEXT.invoke(title), fadeIn, stay, fadeOut);
            ReflectionUtils.sendPacket(player, timesPacket);
            if (title != null) {
                Object titlePacket = PACKET.invoke(TITLE, CHAT_COMPONENT_TEXT.invoke(title), fadeIn, stay, fadeOut);
                ReflectionUtils.sendPacket(player, titlePacket);
            }
            if (subtitle != null) {
                Object subtitlePacket = PACKET.invoke(SUBTITLE, CHAT_COMPONENT_TEXT.invoke(subtitle), fadeIn, stay, fadeOut);
                ReflectionUtils.sendPacket(player, subtitlePacket);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void clearTitle(Player player) {
        Objects.requireNonNull(player, "Cannot clear title from null player");
        Object clearPacket = null;
        try {
            clearPacket = PACKET.invoke(CLEAR, null, -1, -1, -1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ReflectionUtils.sendPacket(player, clearPacket);
    }

    static {
        Class<?> chatComponentText = ReflectionUtils.getNMSClass("ChatComponentText");
        Class<?> packet = ReflectionUtils.getNMSClass("PacketPlayOutTitle");
        Class<?> titleTypes = packet.getDeclaredClasses()[0];
        MethodHandle packetCtor = null;
        MethodHandle chatComp = null;
        Object times = null;
        Object title = null;
        Object subtitle = null;
        Object clear = null;
        block14: for (Object type : titleTypes.getEnumConstants()) {
            switch (type.toString()) {
                case "TIMES": {
                    times = type;
                    continue block14;
                }
                case "TITLE": {
                    title = type;
                    continue block14;
                }
                case "SUBTITLE": {
                    subtitle = type;
                    continue block14;
                }
                case "CLEAR": {
                    clear = type;
                }
            }
        }
        try {
            chatComp = MethodHandles.lookup().findConstructor(chatComponentText, MethodType.methodType(Void.TYPE, String.class));
            packetCtor = MethodHandles.lookup().findConstructor(packet, MethodType.methodType(Void.TYPE, titleTypes, ReflectionUtils.getNMSClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        TITLE = title;
        SUBTITLE = subtitle;
        TIMES = times;
        CLEAR = clear;
        PACKET = packetCtor;
        CHAT_COMPONENT_TEXT = chatComp;
    }
}

