/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slu.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelmimic4<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"slu", (String)"modelmimic_4"), "main");
    public final ModelPart Head;
    public final ModelPart Body;
    public final ModelPart LeftArm;
    public final ModelPart RightArm;
    public final ModelPart LeftLeg;
    public final ModelPart RightLeg;

    public Modelmimic4(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightLeg = root.getChild("RightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, -3.999f, -1.9564f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.6f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition group = Head.addOrReplaceChild("group", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -38.2557f, -12.5117f, 16.0f, 8.0f, 16.0f, new CubeDeformation(0.1f)).texOffs(52, 50).addBox(5.5f, -31.0057f, -12.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(52, 46).addBox(5.5f, -31.0057f, -9.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(46, 52).addBox(5.5f, -31.0057f, -6.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 50).addBox(2.25f, -31.0057f, -12.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(46, 48).addBox(-1.0f, -31.0057f, -12.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 36).addBox(-4.25f, -31.0057f, -12.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 32).addBox(-7.5f, -31.0057f, -12.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 28).addBox(-7.5f, -31.0057f, -9.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 24).addBox(-7.5f, -31.0057f, -6.2617f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0067f, (float)0.3053f));
        PartDefinition cube_r1 = group.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 31).addBox(-15.5f, -3.5622f, 1.4643f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 31).addBox(-15.5f, -3.5622f, 4.4643f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 35).addBox(-15.5f, -3.5622f, -1.5357f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 35).addBox(-12.25f, -3.5622f, -1.5357f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 46).addBox(-9.0f, -3.5622f, -1.5357f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(-5.75f, -3.5622f, -1.5357f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 4).addBox(-2.5f, -3.5622f, -1.5357f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 8).addBox(-2.5f, -3.5622f, 1.4643f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 12).addBox(-2.5f, -3.5622f, 4.4643f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-16.0f, -2.5622f, -2.5357f, 16.0f, 6.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)-23.0f, (float)-8.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = group.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 24).addBox(0.0f, 11.7557f, -4.5117f, 16.0f, 6.0f, 16.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)8.0f, (float)-23.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 46).addBox(-4.0f, -2.2396f, -0.9327f, 8.0f, 10.0f, 4.0f, new CubeDeformation(0.35f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(24, 46).addBox(-0.8044f, -2.5138f, -1.8353f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.35f)), PartPose.offsetAndRotation((float)5.0f, (float)4.0f, (float)0.0f, (float)-0.9042f, (float)-0.5228f, (float)-0.2277f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(24, 46).mirror().addBox(-1.1956f, -2.5138f, -1.8353f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.35f)).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)4.0f, (float)0.0f, (float)-0.9042f, (float)0.5228f, (float)0.2277f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.2739f, -1.3218f, -1.3756f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.35f)), PartPose.offset((float)2.65f, (float)12.0f, (float)1.25f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-0.2261f, -1.3218f, -1.3756f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.35f)).mirror(false), PartPose.offset((float)-3.15f, (float)12.0f, (float)1.25f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

