/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slu.entity;

import javax.annotation.Nullable;
import net.mcreator.slu.init.SluModEntities;
import net.mcreator.slu.init.SluModItems;
import net.mcreator.slu.procedures.MobDieCodeProcedure;
import net.mcreator.slu.procedures.NoFightingCodeProcedure;
import net.mcreator.slu.procedures.NoTeleportCodeProcedure;
import net.mcreator.slu.procedures.NpcRightClickCodeProcedure;
import net.mcreator.slu.procedures.WhitePhantomInitialSpawnCodeProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class WhitePhantomEntity
extends TamableAnimal {
    public WhitePhantomEntity(EntityType<WhitePhantomEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SluModItems.LONGSWORD.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)SluModItems.ROUND_SHIELD.get()));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)SluModItems.NORTH_KNIGHT_HELMET.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)SluModItems.NORTH_KNIGHT_CHESTPLATE.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)SluModItems.NORTH_KNIGHT_LEGGINGS.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)SluModItems.NORTH_KNIGHT_BOOTS.get()));
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false){

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoFightingCodeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new FollowOwnerGoal(this, 1.6, 10.0f, 2.0f){

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoTeleportCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoTeleportCodeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoTeleportCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoTeleportCodeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canUse() && NoTeleportCodeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WhitePhantomEntity.this.getX();
                double y = WhitePhantomEntity.this.getY();
                double z = WhitePhantomEntity.this.getZ();
                WhitePhantomEntity entity = WhitePhantomEntity.this;
                Level world = WhitePhantomEntity.this.level();
                return super.canContinueToUse() && NoTeleportCodeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"slu:real_heavy_walking")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.iron_golem.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"slu:npc_death"));
    }

    public void die(DamageSource source) {
        super.die(source);
        MobDieCodeProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), source, (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        WhitePhantomInitialSpawnCodeProcedure.execute((Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.SUCCESS;
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.SUCCESS;
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.SUCCESS;
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        WhitePhantomEntity entity = this;
        Level world = this.level();
        NpcRightClickCodeProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        WhitePhantomEntity retval = (WhitePhantomEntity)((EntityType)SluModEntities.WHITE_PHANTOM.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike)((ItemLike)SluModItems.HEALINGSTONE.get())).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.22);
        builder = builder.add(Attributes.MAX_HEALTH, 120.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        return builder;
    }
}

