/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.util.TextHelper;
import dev.wp.industrialization_overdrive.IOBlocks;
import dev.wp.industrialization_overdrive.IOComponents;
import dev.wp.industrialization_overdrive.IOConfig;
import dev.wp.industrialization_overdrive.IODataMaps;
import dev.wp.industrialization_overdrive.IOItems;
import dev.wp.industrialization_overdrive.IOOtherRegistries;
import dev.wp.industrialization_overdrive.IOText;
import dev.wp.industrialization_overdrive.IOUtil;
import dev.wp.industrialization_overdrive.compat.AE2Integration;
import dev.wp.industrialization_overdrive.datagen.client.provider.LanguageDatagenProvider;
import dev.wp.industrialization_overdrive.machines.blockentities.multiblock.PyrolyseOvenBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MIParser;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.lang.LangManager;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="industrialization_overdrive")
public final class IO {
    public static final String ID = "industrialization_overdrive";
    public static final String NAME = "Industrialization Overdrive";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Industrialization Overdrive");
    private static IOText TEXT;

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)name);
    }

    public IO(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)IOConfig.SPEC);
        IO.setupText();
        IOConfig.loadConfig();
        bus.addListener(FMLCommonSetupEvent.class, event -> IOConfig.loadConfig());
        TesseractMI.init((String)ID);
        IOComponents.init(bus);
        IOItems.init(bus);
        IOBlocks.init(bus);
        IOOtherRegistries.init(bus);
        bus.addListener(FMLCommonSetupEvent.class, event -> {
            IOItems.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            IOBlocks.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            if (IOUtil.isAE2Loaded) {
                AE2Integration.registerItems();
            }
        });
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
        bus.addListener(RegisterDataMapTypesEvent.class, IODataMaps::init);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, DataMapsUpdatedEvent.class, event -> event.ifRegistry(Registries.BLOCK, registry -> PyrolyseOvenBlockEntity.initTiers()));
    }

    public static IOText text() {
        Assert.notNull((Object)TEXT, (String)"Text not initialized yet");
        return TEXT;
    }

    private static void setupText() {
        LangInstance instance = new LangManager(ID).builtinColorStyles().style("tooltip", () -> MITooltips.DEFAULT_STYLE).style("highlighted", () -> MITooltips.HIGHLIGHT_STYLE).builtinParsers().parser("percentage", Float.TYPE, () -> value -> Parser.FLOAT_PERCENTAGE.parse(value, (Object)0)).parser("eu_per_tick", Long.TYPE, () -> value -> {
            TextHelper.Amount amount = TextHelper.getAmountGeneric((Number)value);
            return MIText.EuT.text(new Object[]{amount.digit(), amount.unit()});
        }).parser("eu", Long.TYPE, () -> value -> {
            TextHelper.Amount amount = TextHelper.getAmountGeneric((Number)value);
            return MIText.Eu.text(new Object[]{amount.digit(), amount.unit()});
        }).parser(EuCostTransformer.class, () -> MIParser.EU_COST_TRANSFORMER_PARSER).parser("block_pos", BlockPos.class, () -> Parser.BLOCK_POS).parser("keybind", String.class, () -> Parser.KEYBIND).build(IOText.class).load();
        LanguageDatagenProvider.include(instance);
        TEXT = (IOText)instance.lang();
    }
}

