/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.datagen.server.provider.recipes;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.property.MaterialHardness;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import dev.wp.industrialization_overdrive.IO;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;
import net.swedz.tesseract.neoforge.helper.RecipeHelper;
import org.jetbrains.annotations.NotNull;

public abstract class RecipesServerDatagenProvider
extends RecipeProvider {
    protected RecipesServerDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    protected static Ingredient ingredient(String maybeTag) {
        return RecipeHelper.ingredient((String)maybeTag);
    }

    protected static boolean hasPart(Material material, PartTemplate part) {
        return material.getParts().containsKey(part.key());
    }

    protected static void addMachineRecipe(String path, String name, MachineRecipeType recipeType, int eu, int duration, Consumer<MIMachineRecipeBuilder> recipeBuilder, RecipeOutput output) {
        MIMachineRecipeBuilder recipe = new MIMachineRecipeBuilder(recipeType, eu, duration);
        recipeBuilder.accept(recipe);
        recipe.offerTo(output, IO.id(path + "/" + name));
    }

    protected static void addMaterialMachineRecipe(Material material, String name, MachineRecipeType recipeType, int eu, int duration, Consumer<MIMachineRecipeBuilder> recipeBuilder, RecipeOutput output) {
        RecipesServerDatagenProvider.addMachineRecipe("materials/%s/%s".formatted(material.name, recipeType.getPath()), name, recipeType, eu, duration, recipeBuilder, output);
    }

    protected static void addMaterialMachineRecipe(Material material, String name, MachineRecipeType recipeType, int eu, Consumer<MIMachineRecipeBuilder> recipeBuilder, RecipeOutput output) {
        RecipesServerDatagenProvider.addMaterialMachineRecipe(material, name, recipeType, eu, (int)(200.0 * ((MaterialHardness)material.get((MaterialProperty)MaterialProperty.HARDNESS)).timeFactor), recipeBuilder, output);
    }

    @NotNull
    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

