/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.machines.blockentities.multiblock;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.common.collect.Lists;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.IOConfig;
import dev.wp.industrialization_overdrive.IOTags;
import dev.wp.industrialization_overdrive.machines.components.craft.MultiProcessingArrayMachineComponent;
import dev.wp.industrialization_overdrive.machines.guicomponents.multiprocessingarraymachineslot.MultiProcessingArrayMachineSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformers;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractElectricMultipliedCraftingMultiblockBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.machine.multiblock.member.PredicateSimpleMember;

public final class MultiProcessingArrayBlockEntity
extends AbstractElectricMultipliedCraftingMultiblockBlockEntity {
    private final MultiProcessingArrayMachineComponent machines;
    private static final int MAX_MACHINES = 64;
    private static final int SPLIT = 4;
    private static final int BASE_MACHINES = 8;
    private static final int MULT_MACHINES = 2;
    private static final ShapeTemplate[] SHAPE_TEMPLATES = new ShapeTemplate[4];

    public MultiProcessingArrayBlockEntity(BEP bep) {
        super(bep, IO.id("multi_processing_array"), SHAPE_TEMPLATES, MachineTier.MULTIBLOCK);
        if (!IOConfig.allowUpgradesInMultiProcessingArray) {
            SlotPanel.Server slotPanel = (SlotPanel.Server)this.guiComponents.get(SlotPanel.Server.class);
            if (slotPanel != null) {
                this.guiComponents.unregister((Object[])new GuiComponent.Server[]{slotPanel});
            }
            this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withOverdrive(this.overdrive)});
        }
        this.machines = new MultiProcessingArrayMachineComponent();
        this.registerComponents(new IComponent[]{this.machines});
        this.registerGuiComponent(new GuiComponent.Server[]{new MultiProcessingArrayMachineSlot.Server((MachineBlockEntity)this, () -> this.getMachineStackSize(this.activeShape.getActiveShapeIndex()), this.machines)});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        ShapeSelection.LineInfo[] lineInfoArray = new ShapeSelection.LineInfo[1];
        lineInfoArray[0] = new ShapeSelection.LineInfo(4, IntStream.range(0, 4).map(this::getMachineStackSize).mapToObj(IO.text()::multiProcessingArraySize).toList(), false);
        serverArray[0] = new ShapeSelection.Server(new ShapeSelection.Behavior(){

            public void handleClick(int clickedLine, int delta) {
                int newShapeIndex = Mth.clamp((int)(MultiProcessingArrayBlockEntity.this.activeShape.getActiveShapeIndex() + delta), (int)0, (int)(SHAPE_TEMPLATES.length - 1));
                int newMachineStackSize = MultiProcessingArrayBlockEntity.this.getMachineStackSize(newShapeIndex);
                if (newMachineStackSize < MultiProcessingArrayBlockEntity.this.machines.getMachines().getCount()) {
                    return;
                }
                MultiProcessingArrayBlockEntity.this.activeShape.incrementShape((MultiblockMachineBlockEntity)MultiProcessingArrayBlockEntity.this, delta);
            }

            public int getCurrentIndex(int line) {
                return MultiProcessingArrayBlockEntity.this.activeShape.getActiveShapeIndex();
            }
        }, lineInfoArray);
        this.registerGuiComponent(serverArray);
    }

    public MachineRecipeType getRecipeType() {
        return this.machines.getMachineRecipeType();
    }

    public int getMaxMultiplier() {
        return this.machines.getMachineCount();
    }

    public EuCostTransformer getEuCostTransformer() {
        return EuCostTransformers.percentage(() -> Float.valueOf((float)IOConfig.multiProcessingArrayEuCostMultiplier));
    }

    private int getMachineStackSize(int sizeIndex) {
        return (int)(8.0 * Math.pow(2.0, sizeIndex));
    }

    public List<Component> getTooltips() {
        ArrayList lines = Lists.newArrayList();
        lines.add(IO.text().multiProcessingArrayRecipe());
        lines.add(IO.text().multiProcessingArrayBatchSize());
        if (IOConfig.multiProcessingArrayEuCostMultiplier != 1.0) {
            lines.add(IO.text().multiProcessingArrayEuCostMultiplier(this.getEuCostTransformer()));
        }
        return lines;
    }

    public ShapeTemplate getBigShape() {
        return SHAPE_TEMPLATES[SHAPE_TEMPLATES.length - 1];
    }

    public static void registerReiShapes() {
        int index = 0;
        for (ShapeTemplate shapeTemplate : SHAPE_TEMPLATES) {
            ReiMachineRecipes.registerMultiblockShape((ResourceLocation)IO.id("multi_processing_array"), (ShapeTemplate)shapeTemplate, (String)("" + index));
            ++index;
        }
    }

    static {
        SimpleMember casing = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"solid_titanium_machine_casing"))));
        SimpleMember pipe = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"titanium_machine_casing_pipe"))));
        PredicateSimpleMember glass = new PredicateSimpleMember(state -> state.is(IOTags.blockCommon("glass_blocks")), Blocks.GLASS);
        HatchFlags front = new HatchFlags.Builder().with(HatchTypes.ENERGY_INPUT).build();
        HatchFlags top = new HatchFlags.Builder().with(new HatchType[]{HatchTypes.ITEM_INPUT, HatchTypes.FLUID_INPUT}).build();
        HatchFlags bottom = new HatchFlags.Builder().with(new HatchType[]{HatchTypes.ITEM_OUTPUT, HatchTypes.FLUID_OUTPUT}).build();
        int i = 0;
        int size = 3;
        for (int machines = 8; i < 4 && machines <= 64; machines *= 2) {
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.SOLID_TITANIUM);
            for (int z = 0; z < size; ++z) {
                boolean isFront = z == 0;
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        boolean isGlass;
                        boolean isTop = y == 1;
                        boolean isBottom = y == -1;
                        boolean isCenter = x == 0 && y == 0;
                        boolean bl = isGlass = x != 0 && y == 0;
                        builder.add(x, y, z, (SimpleMember)(isCenter ? pipe : (isGlass ? glass : casing)), isGlass ? null : (isFront ? front : (isTop ? top : (isBottom ? bottom : null))));
                    }
                }
            }
            MultiProcessingArrayBlockEntity.SHAPE_TEMPLATES[i] = builder.build();
            ++i;
            size += 2;
        }
    }
}

