/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.machines.guicomponents.multiprocessingarraymachineslot;

import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.Rectangle;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.machines.guicomponents.multiprocessingarraymachineslot.MultiProcessingArrayMachineSlot;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MultiProcessingArrayMachineSlotClient
implements GuiComponentClient {
    private int maxMachines;

    public MultiProcessingArrayMachineSlotClient(RegistryFriendlyByteBuf buf) {
        this.readCurrentData(buf);
    }

    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.maxMachines = buf.readInt();
    }

    public void setupMenu(final GuiComponent.MenuFacade menu) {
        class ClientSlot
        extends SlotWithBackground
        implements SlotTooltip {
            public ClientSlot() {
                super((Container)new SimpleContainer(1), 0, MultiProcessingArrayMachineSlot.getSlotX(menuFacade.getGuiParams()), MultiProcessingArrayMachineSlot.getSlotY());
            }

            public boolean mayPlace(ItemStack itemStack) {
                return MultiProcessingArrayMachineSlot.isMachine(itemStack.getItem());
            }

            public int getMaxStackSize() {
                return MultiProcessingArrayMachineSlotClient.this.maxMachines;
            }

            public int getBackgroundU() {
                return 18;
            }

            public int getBackgroundV() {
                return 80;
            }

            @Override
            public Component getTooltip() {
                return IO.text().multiProcessingArrayMachineInput();
            }
        }
        menu.addSlotToMenu((Slot)new ClientSlot(), SlotGroup.CONFIGURABLE_STACKS);
    }

    public ClientComponentRenderer createRenderer(final MachineScreen machineScreen) {
        return new ClientComponentRenderer(){

            private Rectangle getBox(int leftPos, int topPos) {
                return new Rectangle(leftPos + machineScreen.getGuiParams().backgroundWidth, topPos + 10 + MultiProcessingArrayMachineSlot.getSlotY() - 19, 31, 34);
            }

            public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
                rectangles.add(this.getBox(leftPos, topPos));
            }

            public void renderBackground(GuiGraphics graphics, int leftPos, int topPos) {
                Rectangle box = this.getBox(leftPos, topPos);
                int textureX = box.x() - leftPos - box.w();
                graphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), textureX, 0, box.w(), box.h() - 4);
                graphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, textureX, 252, box.w(), 4);
            }

            public void renderTooltip(MachineScreen screen, Font font, GuiGraphics graphics, int x, int y, int cursorX, int cursorY) {
                Slot slot = screen.getFocusedSlot();
                if (slot instanceof SlotTooltip) {
                    SlotTooltip st = (SlotTooltip)slot;
                    if (!screen.getFocusedSlot().hasItem()) {
                        graphics.renderTooltip(font, st.getTooltip(), cursorX, cursorY);
                    }
                }
            }
        };
    }

    private static class SlotWithBackground
    extends Slot
    implements BackgroundRenderedSlot {
        public SlotWithBackground(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }
    }

    static interface SlotTooltip {
        public Component getTooltip();
    }
}

