/*
 * Decompiled with CFR 0.152.
 */
package yuuria.stackupper.stackupper.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={GuiGraphics.class}, remap=false)
public abstract class GuiGraphicsClient {
    private static final DecimalFormat BILLION_FORMAT = new DecimalFormat("#.##B");
    private static final DecimalFormat MILLION_FORMAT = new DecimalFormat("#.##M");
    private static final DecimalFormat THOUSAND_FORMAT = new DecimalFormat("#.##K");

    @Shadow
    public abstract void drawString(Font var1, String var2, int var3, int var4, int var5, boolean var6);

    @Shadow
    protected abstract void renderItemCount(Font var1, ItemStack var2, int var3, int var4, String var5);

    private static String getStringForBigStackCount(int count) {
        BigDecimal decimal = new BigDecimal(count).round(new MathContext(3));
        double val = decimal.doubleValue();
        if (val >= 1.0E9) {
            return BILLION_FORMAT.format(val / 1.0E9);
        }
        if (val >= 1000000.0) {
            return MILLION_FORMAT.format(val / 1000000.0);
        }
        if (val >= 1000.0) {
            return THOUSAND_FORMAT.format(val / 1000.0);
        }
        return String.valueOf(count);
    }

    private static double calculateStringScale(Font font, String countString) {
        int width = font.width(countString);
        if (width < 16) {
            return 1.0;
        }
        return 16.0 / (double)width;
    }

    @WrapOperation(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItemCount(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V")})
    private void renderText(GuiGraphics instance, Font font, ItemStack stack, int x, int y, String text, Operation<Void> original) {
        if (text != null || stack.getCount() != 1) {
            Matrix3x2fStack poseStack = instance.pose();
            String text_ = text == null ? GuiGraphicsClient.getStringForBigStackCount(stack.getCount()) : text;
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            float scale = (float)GuiGraphicsClient.calculateStringScale(font, text_);
            float inverseScale = 1.0f / scale;
            float drawX = (float)(x + 16) * inverseScale - (float)font.width(text_);
            float f = (float)(y + 16) * inverseScale;
            Objects.requireNonNull(font);
            float drawY = f - 9.0f;
            int mcX = x + 19 - 2 - font.width(text_);
            int mcY = y + 6 + 3;
            poseStack.pushMatrix();
            poseStack.scale(scale);
            this.drawString(font, text_, (int)drawX, (int)drawY, -1, true);
            poseStack.popMatrix();
        }
    }
}

