/*
 * Decompiled with CFR 0.152.
 */
package yuuria.stackupper.stackupper;

import java.io.File;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yuuria.stackupper.configlibrary.Constant;
import yuuria.stackupper.configlibrary.Property;
import yuuria.stackupper.configlibrary.ast.AssignOperator;
import yuuria.stackupper.stackupper.StackUpperConfig;

public class Constants {
    public static final int BILLION = 1000000000;
    public static final int MILLION = 1000000;
    public static final int THOUSAND = 1000;
    public static final DecimalFormat TOOLTIP_FORMAT = new DecimalFormat("###,###,###,###,###,###");
    public static final File StackUpperConfigRuleset = new File(FMLPaths.CONFIGDIR.get().toFile().toString(), "stackupper");
    public static final Logger logger = LoggerFactory.getLogger((String)"StackUpper");
    public static final int MAX_STACK_LIMIT = 64;
    public static final Supplier<Integer> globalStackLimitSupplier = () -> {
        int max;
        int n = max = 64 == StackUpperConfig.CONFIG.maxStackGlobally.getAsInt() ? 64 : StackUpperConfig.CONFIG.maxStackGlobally.getAsInt();
        if (Constant.ItemCollection.isEmpty()) {
            return max;
        }
        for (Property property : Constant.ItemCollection.values()) {
            if (property.assignOperator == AssignOperator.EQUAL) {
                max = Math.max(property.assignedBy.intValue(), max);
                continue;
            }
            max = (int)Math.max(property.assignOperator.apply(property.assignedBy, property.origStackSize), (long)max);
        }
        return max;
    };
}

