/*
 * Decompiled with CFR 0.152.
 */
package yuuria.stackupper.stackupper.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, remap=false)
public abstract class GuiGraphicsClient {
    @Shadow
    @Final
    private PoseStack pose;
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;
    private static final DecimalFormat BILLION_FORMAT = new DecimalFormat("#.##B");
    private static final DecimalFormat MILLION_FORMAT = new DecimalFormat("#.##M");
    private static final DecimalFormat THOUSAND_FORMAT = new DecimalFormat("#.##K");

    @Shadow
    @Deprecated
    protected abstract void flushIfUnmanaged();

    private static String getStringForBigStackCount(int count) {
        BigDecimal decimal = new BigDecimal(count).round(new MathContext(3));
        double val = decimal.doubleValue();
        if (val >= 1.0E9) {
            return BILLION_FORMAT.format(val / 1.0E9);
        }
        if (val >= 1000000.0) {
            return MILLION_FORMAT.format(val / 1000000.0);
        }
        if (val >= 1000.0) {
            return THOUSAND_FORMAT.format(val / 1000.0);
        }
        return String.valueOf(count);
    }

    private static double calculateStringScale(Font font, String countString) {
        int width = font.width(countString);
        if (width < 16) {
            return 1.0;
        }
        return 16.0 / (double)width;
    }

    @WrapOperation(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private void PoseStackTranslate(PoseStack instance, float x, float y, float z, Operation<Void> original) {
    }

    @WrapOperation(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I")})
    private int NoDrawStr(GuiGraphics instance, Font font, String text, int x, int y, int color, boolean dropShadow, Operation<Integer> original) {
        return 0;
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I", ordinal=0)})
    private void renderText(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci) {
        String text_ = text == null ? GuiGraphicsClient.getStringForBigStackCount(stack.getCount()) : text;
        float scale = (float)GuiGraphicsClient.calculateStringScale(font, text_);
        float i_scale = 1.0f / scale;
        this.pose.scale(scale, scale, 1.0f);
        float custom_X = (float)(x + 16) * i_scale - (float)font.width(text_);
        float f = (float)(y + 16) * i_scale;
        Objects.requireNonNull(font);
        float custom_Y = f - 9.0f;
        this.pose.translate(0.0f, 0.0f, 200.0f);
        font.drawInBatch(text_, custom_X, custom_Y, 0xFFFFFF, true, this.pose.last().pose(), (MultiBufferSource)this.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.flushIfUnmanaged();
    }
}

