/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render.feature;

import java.awt.Color;
import net.emilsg.clutterbestiary.entity.client.layer.ModModelLayers;
import net.emilsg.clutterbestiary.entity.client.model.KoiModel;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_922;

public class KoiBaseColorFeatureRenderer
extends class_3887<KoiEntity, KoiModel<KoiEntity>> {
    private final KoiModel<KoiEntity> layerModel;

    public KoiBaseColorFeatureRenderer(class_3883<KoiEntity, KoiModel<KoiEntity>> context, class_5599 loader) {
        super(context);
        this.layerModel = new KoiModel(loader.method_32072(ModModelLayers.KOI_BASE));
    }

    private static int getColor(KoiEntity koiEntity, float tickDelta) {
        int color;
        if (koiEntity.getBaseColorVariant().equals(KoiBaseColorVariant.IRIDESCENT_RAINBOW)) {
            float speed = 4.5f;
            float hue = ((float)koiEntity.field_6012 + tickDelta) * speed % 360.0f / 360.0f;
            float saturation = 0.4f;
            float brightness = 1.0f;
            color = Color.HSBtoRGB(hue, saturation, brightness);
        } else {
            if (koiEntity.getBaseColorVariant().hasSeparateTexture()) {
                return 0;
            }
            color = koiEntity.getBaseColorVariant().getColorHex()[0];
        }
        return color;
    }

    public void render(class_4587 matrices, class_4597 providers, int light, KoiEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        int rgb = KoiBaseColorFeatureRenderer.getColor(entity, tickDelta);
        if (rgb == 0) {
            return;
        }
        int argb = 0xFF000000 | rgb & 0xFFFFFF;
        class_2960 texture = this.method_23194((class_1297)entity);
        if (entity.method_5767()) {
            class_310 mc = class_310.method_1551();
            if (mc.method_27022((class_1297)entity)) {
                ((KoiModel)this.method_17165()).method_17081((class_583)this.layerModel);
                this.layerModel.method_2816((class_1297)entity, limbAngle, limbDistance, tickDelta);
                this.layerModel.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                class_4588 vc = providers.getBuffer(class_1921.method_23287((class_2960)texture));
                this.layerModel.method_2828(matrices, vc, light, class_922.method_23622((class_1309)entity, (float)0.0f), -16777216);
            }
            return;
        }
        KoiBaseColorFeatureRenderer.method_23196((class_583)this.method_17165(), this.layerModel, (class_2960)texture, (class_4587)matrices, (class_4597)providers, (int)light, (class_1309)entity, (float)limbAngle, (float)limbDistance, (float)animationProgress, (float)headYaw, (float)headPitch, (float)tickDelta, (int)argb);
    }
}

