/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.time.LocalDate;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyDupeSporeBlossomGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyPlaceCocoonGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyWanderNetherGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyWanderOverworldGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.variants.ButterflyVariant;
import net.emilsg.clutterbestiary.item.ModItems;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ButterflyEntity
extends ParentAnimalEntity {
    private static final class_2940<Boolean> HAS_COCOON = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DUPE_TIMER = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> VARIANT = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> FLYING_TYPE_VARIANT = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13327);
    public final class_7094 flyingAnimState = new class_7094();
    private int animationTimeout = 0;

    public ButterflyEntity(class_1299<? extends ParentAnimalEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.field_6206 = new ButterflyLookControl((class_1308)this);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return ParentAnimalEntity.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23720, 0.5).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23717, 16.0);
    }

    private static boolean isTodayAroundHalloween() {
        LocalDate localDate = LocalDate.now();
        int i = localDate.getDayOfMonth();
        int j = localDate.getMonth().getValue();
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModBlockTags.BUTTERFLIES_SPAWN_ON);
    }

    public void method_24650(class_3218 world, class_1429 other) {
        super.method_24650(world, other);
        class_3222 serverPlayerEntity = this.method_6478();
        if (serverPlayerEntity == null && other.method_6478() != null) {
            serverPlayerEntity = other.method_6478();
        }
        if (serverPlayerEntity != null) {
            serverPlayerEntity.method_7281(class_3468.field_15410);
            class_174.field_1190.method_855(serverPlayerEntity, (class_1429)this, other, null);
        }
        this.setHasCocoon(true);
        this.method_5614(6000);
        other.method_5614(6000);
        this.method_6477();
        other.method_6477();
        world.method_8421((class_1297)this, (byte)18);
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    public void copyDataFromNbt(ButterflyEntity entity, class_2487 nbt) {
        if (nbt.method_10545("NoAI")) {
            entity.method_5977(nbt.method_10577("NoAI"));
        }
        if (nbt.method_10545("Silent")) {
            entity.method_5803(nbt.method_10577("Silent"));
        }
        if (nbt.method_10545("NoGravity")) {
            entity.method_5875(nbt.method_10577("NoGravity"));
        }
        if (nbt.method_10545("Glowing")) {
            entity.method_5834(nbt.method_10577("Glowing"));
        }
        if (nbt.method_10545("Invulnerable")) {
            entity.method_5684(nbt.method_10577("Invulnerable"));
        }
        if (nbt.method_10545("FlyingVariant")) {
            entity.setFlyingVariant(nbt.method_10550("FlyingVariant"));
        }
        if (nbt.method_10545("Variant")) {
            entity.setVariant(ButterflyVariant.fromId(nbt.method_10558("Variant")));
        }
        if (nbt.method_10573("Health", 99)) {
            entity.method_6033(nbt.method_10583("Health"));
        }
    }

    public void copyDataToStack(ButterflyEntity entity, class_1799 stack) {
        stack.method_57379(class_9334.field_49631, (Object)entity.method_5797());
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> {
            if (entity.method_5987()) {
                nbtCompound.method_10556("NoAI", entity.method_5987());
            }
            if (entity.method_5701()) {
                nbtCompound.method_10556("Silent", entity.method_5701());
            }
            if (entity.method_5740()) {
                nbtCompound.method_10556("NoGravity", entity.method_5740());
            }
            if (entity.method_5851()) {
                nbtCompound.method_10556("Glowing", entity.method_5851());
            }
            if (entity.method_5655()) {
                nbtCompound.method_10556("Invulnerable", entity.method_5655());
            }
            nbtCompound.method_10548("Health", entity.method_6032());
            nbtCompound.method_10582("Variant", entity.getTypeVariant());
        });
    }

    public int getDupeTimer() {
        return (Integer)this.field_6011.method_12789(DUPE_TIMER);
    }

    public void setDupeTimer(int time) {
        this.field_6011.method_12778(DUPE_TIMER, (Object)time);
    }

    public int getFlyingTypeVariant() {
        return (Integer)this.field_6011.method_12789(FLYING_TYPE_VARIANT);
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return world.method_8320(pos).method_26215() ? 10.0f : 0.0f;
    }

    public String getTypeVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public ButterflyVariant getVariant() {
        return ButterflyVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(ButterflyVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean hasCocoon() {
        return (Boolean)this.field_6011.method_12789(HAS_COCOON);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_6880 registryEntry = world.method_23753(this.method_24515());
        ButterflyVariant variant = ButterflyVariant.getRandom(false);
        if (spawnReason.equals((Object)class_3730.field_16465)) {
            variant = (ButterflyVariant)((Object)class_156.method_27173((Object[])ButterflyVariant.values(), (class_5819)this.field_5974));
        }
        if (registryEntry.method_40220(class_6908.field_37393)) {
            variant = ButterflyVariant.getRandom(true);
        } else if (registryEntry.method_40220(class_6908.field_36518)) {
            variant = registryEntry.method_40225(class_1972.field_22075) ? ButterflyVariant.WARPED : (registryEntry.method_40225(class_1972.field_22077) ? ButterflyVariant.CRIMSON : (registryEntry.method_40225(class_1972.field_22076) ? ButterflyVariant.SOUL : (this.field_5974.method_43056() ? ButterflyVariant.CRIMSON : (this.field_5974.method_43056() ? ButterflyVariant.WARPED : ButterflyVariant.SOUL))));
        }
        this.setVariant(variant);
        this.setFlyingVariant(this.field_5974.method_43048(3));
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        this.tryBottle(player, hand, this);
        return super.method_5992(player, hand);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8479);
    }

    public boolean method_41330() {
        return true;
    }

    public boolean method_5753() {
        return this.getVariant().isFireImmune();
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasCocoon(nbt.method_10577("HasCocoon"));
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10558("Variant"));
        this.setDupeTimer(nbt.method_10550("DupeTimer"));
        this.field_6011.method_12778(FLYING_TYPE_VARIANT, (Object)nbt.method_10550("FlyingVariant"));
    }

    public void setFlyingVariant(int flyingVariant) {
        this.field_6011.method_12778(FLYING_TYPE_VARIANT, (Object)flyingVariant);
    }

    public void setHasCocoon(boolean hasCocoon) {
        this.field_6011.method_12778(HAS_COCOON, (Object)hasCocoon);
    }

    public boolean method_27298() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.getDupeTimer() < 8000) {
            this.setDupeTimer(this.getDupeTimer() + 1);
        }
        if (this.method_5805() && (this.method_5777(class_3486.field_15518) || this.method_5777(class_3486.field_15517))) {
            this.method_5768();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasCocoon", this.hasCocoon());
        nbt.method_10582("Variant", this.getTypeVariant());
        nbt.method_10569("DupeTimer", this.getDupeTimer());
        nbt.method_10569("FlyingVariant", this.getFlyingTypeVariant());
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407(this, (class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_14983;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14628;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_COCOON, (Object)false);
        builder.method_56912(DUPE_TIMER, (Object)0);
        builder.method_56912(VARIANT, (Object)ButterflyVariant.WHITE.getId());
        builder.method_56912(FLYING_TYPE_VARIANT, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new ButterflyPlaceCocoonGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.25, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8479}), false));
        this.field_6201.method_6277(3, (class_1352)new ButterflyDupeSporeBlossomGoal(this, 1.0, 1200));
        this.field_6201.method_6277(4, (class_1352)new ButterflyWanderNetherGoal(this));
        this.field_6201.method_6277(4, (class_1352)new ButterflyWanderOverworldGoal(this));
    }

    protected void method_23733(@Nullable class_1309 adversary) {
        if (ButterflyEntity.isTodayAroundHalloween() && adversary instanceof class_1657 && this.field_5974.method_43048(10) == 0) {
            adversary.method_5643(this.method_37908().method_48963().method_48831(), 6.0f);
        }
        super.method_23733(adversary);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 10;
            this.flyingAnimState.method_41322(this.field_6012);
        } else {
            --this.animationTimeout;
        }
    }

    private void tryBottle(class_1657 player, class_1268 hand, ButterflyEntity entity) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8469 && entity.method_5805()) {
            entity.method_5783(class_3417.field_15029, 1.0f, 0.75f);
            class_1799 bottleStack = new class_1799((class_1935)ModItems.BUTTERFLY_IN_A_BOTTLE.get());
            this.copyDataToStack(entity, bottleStack);
            class_1799 butterflyBottleStack = class_5328.method_30270((class_1799)itemStack, (class_1657)player, (class_1799)bottleStack, (boolean)false);
            player.method_6104(hand);
            player.method_6122(hand, butterflyBottleStack);
            entity.method_31472();
        }
    }

    static class ButterflyLookControl
    extends class_1333 {
        ButterflyLookControl(class_1308 entity) {
            super(entity);
        }

        public void method_6231() {
            super.method_6231();
        }

        protected boolean method_20433() {
            return true;
        }
    }
}

