/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4174;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class CapybaraEntity
extends ParentTameableEntity {
    private static final class_2940<Boolean> IS_SLEEPING = class_2945.method_12791(CapybaraEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FORCE_SLEEPING = class_2945.method_12791(CapybaraEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SLEEPER = class_2945.method_12791(CapybaraEntity.class, (class_2941)class_2943.field_13327);
    private static final class_1856 BREEDING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_17522});
    public final class_7094 earTwitchAnimationStateOne = new class_7094();
    public final class_7094 earTwitchAnimationStateTwo = new class_7094();
    public final class_7094 sleepingAnimationState = new class_7094();
    public int earTwitchAnimationTimeout = 0;
    public int sleepingAnimationTimeout = 0;

    public CapybaraEntity(class_1299<? extends ParentTameableEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23722, (double)0.1f).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 16.0);
    }

    public void healNearbyEntities(class_1297 centerEntity, double radius) {
        if (this.field_5974.method_43048(1000) != 0) {
            return;
        }
        class_238 area = new class_238(centerEntity.method_23317() - radius, centerEntity.method_23318() - radius, centerEntity.method_23321() - radius, centerEntity.method_23317() + radius, centerEntity.method_23318() + radius, centerEntity.method_23321() + radius);
        List nearbyEntities = centerEntity.method_37908().method_8390(class_1309.class, area, e -> e != centerEntity);
        for (class_1309 entity : nearbyEntities) {
            if (!(entity.method_6032() < entity.method_6063())) continue;
            entity.method_6025(1.0f);
        }
    }

    public boolean method_6482() {
        return super.method_6482() && !this.method_6113();
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)((class_1299)ModEntityTypes.CAPYBARA.get()).method_5883((class_1937)world);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1676) {
            class_1676 projectile = (class_1676)class_12972;
            if (this.method_6113()) {
                projectile.method_18799(projectile.method_18798().method_1021(-1.0));
                return false;
            }
        }
        return super.method_5643(source, amount);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        int sleeperType = this.field_5974.method_39332(0, 2);
        this.setSleeperType(sleeperType);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1792 itemForTaming;
        class_1799 stackInHand = player.method_5998(hand);
        class_1792 item = stackInHand.method_7909();
        if (item == (itemForTaming = class_1802.field_8497) && this.method_6032() < this.method_6063()) {
            class_4174 foodComponent;
            if (!player.method_31549().field_7477) {
                stackInHand.method_7934(1);
            }
            float nutrition = (foodComponent = (class_4174)stackInHand.method_57824(class_9334.field_50075)) != null ? (float)foodComponent.comp_2491() : 1.0f;
            this.method_6025(2.0f * nutrition);
            return class_1269.field_5812;
        }
        if (item == itemForTaming && !this.method_6181()) {
            this.method_5783(class_3417.field_15099, 1.0f, 1.25f);
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                stackInHand.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0 && !this.method_37908().method_8608()) {
                super.method_6170(player);
                this.field_6189.method_6356();
                this.method_6033(this.method_6063());
                this.method_5980(null);
                this.method_6173(true, true);
                this.method_37908().method_8421((class_1297)this, (byte)7);
                this.setIsForceSleeping(true);
                this.setIsSleeping(true);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        if (this.method_6181() && !this.method_37908().method_8608() && hand == class_1268.field_5808 && !stackInHand.method_31574(class_1802.field_8497) && !stackInHand.method_31574(class_1802.field_17522) && this.method_6171((class_1309)player)) {
            this.setIsForceSleeping(!this.method_6113());
            this.setIsSleeping(!this.method_6113());
            return class_1269.field_5812;
        }
        if (stackInHand.method_7909() == itemForTaming) {
            return class_1269.field_5811;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_17522);
    }

    public boolean isForceSleeping() {
        return (Boolean)this.field_6011.method_12789(FORCE_SLEEPING);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(IS_SLEEPING);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setIsSleeping(nbt.method_10577("IsSleeping"));
        this.setIsForceSleeping(nbt.method_10577("IsForceSleeping"));
        this.setSleeperType(nbt.method_10550("Sleeper"));
    }

    public int sleeperType() {
        return (Integer)this.field_6011.method_12789(SLEEPER);
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && !this.method_6181()) {
            this.setIsSleeping(!this.method_37908().method_8530());
        }
        if (!this.method_37908().field_9236 && this.method_6181()) {
            this.setIsSleeping(this.isForceSleeping());
        }
        if (this.method_6113()) {
            this.healNearbyEntities((class_1297)this, 4.0);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("IsSleeping", this.method_6113());
        nbt.method_10556("IsForceSleeping", this.isForceSleeping());
        nbt.method_10569("Sleeper", this.sleeperType());
    }

    void setIsForceSleeping(boolean isSleeping) {
        this.field_6011.method_12778(FORCE_SLEEPING, (Object)isSleeping);
    }

    void setIsSleeping(boolean isSleeping) {
        this.field_6011.method_12778(IS_SLEEPING, (Object)isSleeping);
    }

    void setSleeperType(int type) {
        this.field_6011.method_12778(SLEEPER, (Object)type);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_SLEEPING, (Object)false);
        builder.method_56912(FORCE_SLEEPING, (Object)false);
        builder.method_56912(SLEEPER, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new CapybaraSitGoal(this, this));
        this.field_6201.method_6277(3, (class_1352)new CapybaraEscapeDangerGoal((class_1314)this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new CapybaraMateGoal((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new CapybaraFollowOwnerGoal(this, 1.2, 10.0f, 2.0f));
        this.field_6201.method_6277(6, (class_1352)new CapybaraTemptGoal((class_1314)this, 1.2, BREEDING_INGREDIENT, false));
        this.field_6201.method_6277(7, (class_1352)new class_1353((class_1429)this, 1.2));
        this.field_6201.method_6277(8, (class_1352)new CapybaraWanderGoal((class_1314)this, 1.0, 0.3f));
        this.field_6201.method_6277(9, (class_1352)new CapybaraLookAtEntityGoal((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new CapybaraLookAroundGoal((class_1308)this));
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f * 2.0f, 0.3f);
    }

    private void pickRandomIdleAnim(boolean bl) {
        if (bl) {
            this.earTwitchAnimationStateOne.method_41322(this.field_6012);
        } else {
            this.earTwitchAnimationStateTwo.method_41322(this.field_6012);
        }
    }

    private void setupAnimationStates() {
        if (this.sleepingAnimationTimeout <= 0) {
            this.sleepingAnimationTimeout = 80;
            this.sleepingAnimationState.method_41322(this.field_6012);
        } else {
            --this.sleepingAnimationTimeout;
        }
        if (this.earTwitchAnimationTimeout <= 0 && this.field_5974.method_43048(100) == 0) {
            this.earTwitchAnimationTimeout = 3;
            this.pickRandomIdleAnim(this.field_5974.method_43056());
        } else {
            --this.earTwitchAnimationTimeout;
        }
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModBlockTags.CAPYBARAS_SPAWN_ON);
    }

    private class CapybaraSitGoal
    extends class_1386 {
        private final CapybaraEntity capybara;

        public CapybaraSitGoal(CapybaraEntity capybaraEntity, CapybaraEntity capybara) {
            super((class_1321)capybara);
            this.capybara = capybara;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            super.method_6264();
            return this.capybara.isForceSleeping();
        }

        public boolean method_6266() {
            return this.capybara.isForceSleeping() || this.capybara.method_24345();
        }

        public void method_6269() {
            this.capybara.method_5942().method_6340();
            this.capybara.setIsForceSleeping(true);
        }

        public void method_6270() {
            this.capybara.setIsForceSleeping(false);
            this.capybara.method_6179(false);
        }
    }

    private class CapybaraEscapeDangerGoal
    extends class_1374 {
        public CapybaraEscapeDangerGoal(class_1314 mob, double speed) {
            super(mob, speed);
        }

        public boolean method_6264() {
            return super.method_6264() && !CapybaraEntity.this.method_6113();
        }
    }

    private class CapybaraMateGoal
    extends class_1341 {
        public CapybaraMateGoal(class_1429 animal, double speed) {
            super(animal, speed);
        }

        public boolean method_6264() {
            return super.method_6264() && !CapybaraEntity.this.method_6113();
        }
    }

    private class CapybaraFollowOwnerGoal
    extends class_1350 {
        public CapybaraFollowOwnerGoal(ParentTameableEntity tameable, double speed, float minDistance, float maxDistance) {
            super((class_1321)tameable, speed, minDistance, maxDistance);
        }

        public boolean method_6264() {
            return super.method_6264() && !CapybaraEntity.this.method_6113();
        }
    }

    private class CapybaraTemptGoal
    extends class_1391 {
        public CapybaraTemptGoal(class_1314 entity, double speed, class_1856 food, boolean canBeScared) {
            super(entity, speed, (Predicate)food, canBeScared);
        }

        public boolean method_6264() {
            return super.method_6264() && !CapybaraEntity.this.method_6113();
        }
    }

    private class CapybaraWanderGoal
    extends class_1394 {
        public CapybaraWanderGoal(class_1314 mob, double speed, float probability) {
            super(mob, speed, probability);
        }

        public boolean method_6264() {
            return super.method_6264() && !CapybaraEntity.this.method_6113();
        }

        public void method_6268() {
            if (CapybaraEntity.this.method_6113()) {
                this.method_6270();
                this.field_6566.method_5942().method_6340();
            }
            super.method_6268();
        }
    }

    private class CapybaraLookAtEntityGoal
    extends class_1361 {
        public CapybaraLookAtEntityGoal(class_1308 mob, Class<? extends class_1309> targetType, float range) {
            super(mob, targetType, range);
        }

        public boolean method_6264() {
            return super.method_6264() && !CapybaraEntity.this.method_6113();
        }
    }

    private class CapybaraLookAroundGoal
    extends class_1376 {
        public CapybaraLookAroundGoal(class_1308 mob) {
            super(mob);
        }

        public boolean method_6264() {
            return super.method_6264() && !CapybaraEntity.this.method_6113();
        }
    }
}

