/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseFollowParentGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseLookAroundGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseLookAtEntityGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseMateGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseMeleeGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseTemptGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EmberTortoiseWanderAroundFarGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.emilsg.clutterbestiary.util.ModUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_4760;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5136;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class EmberTortoiseEntity
extends ParentAnimalEntity {
    private static final class_2940<Boolean> MOVING = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ATTACKING = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHIELDING = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SHIELDING_DURATION = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SHIELDING_COOLDOWN = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_1856 BREEDING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8814});
    public static Map<class_2248, class_2248> smeltableBlocksConversionMap = new HashMap<class_2248, class_2248>();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 shieldingAnimationState = new class_7094();
    public final class_7094 shieldingTubeAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public int idleAnimationTimeout = 0;
    public int shieldingAnimationTimeout = 0;
    public int attackAnimationTimeout = 0;
    private int fireSoundTicker = 0;
    private int fireChargeSoundTicker = 0;

    public EmberTortoiseEntity(class_1299<? extends ParentAnimalEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return ParentAnimalEntity.method_26828().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, (double)0.175f).method_26868(class_5134.field_23721, 8.0);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_31574(this.getShieldingRechargeItem())) {
            if (this.canShield()) {
                this.startShielding();
                player.method_5783(class_3417.field_15013, 0.5f + this.field_5974.method_43057(), 0.75f);
                player.method_6104(hand);
                if (!player.method_31549().field_7477) {
                    stackInHand.method_7934(1);
                }
            } else {
                int cooldown = this.getShieldingCooldown();
                this.setShieldingCooldown(cooldown - 100);
            }
        }
        return super.method_5992(player, hand);
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModBlockTags.EMBER_TORTOISES_SPAWN_ON);
    }

    public boolean canShield() {
        return this.getShieldingCooldown() <= 0;
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)((class_1299)ModEntityTypes.EMBER_TORTOISE.get()).method_5883((class_1937)world);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.isShielding()) {
            class_1309 livingEntity = (class_1309)source.method_5529();
            class_1297 class_12972 = source.method_5526();
            if (class_12972 instanceof class_1676) {
                class_1676 projectile = (class_1676)class_12972;
                projectile.method_18799(projectile.method_18798().method_1021(-1.0));
                return false;
            }
            if (livingEntity != null && livingEntity.method_6047().method_7909() instanceof class_1810) {
                return super.method_5643(source, amount * 2.0f);
            }
            return super.method_5643(source, amount / 16.0f);
        }
        return super.method_5643(source, amount);
    }

    public int getShieldingCooldown() {
        return (Integer)this.field_6011.method_12789(SHIELDING_COOLDOWN);
    }

    public void setShieldingCooldown(int shieldingCooldown) {
        this.field_6011.method_12778(SHIELDING_COOLDOWN, (Object)shieldingCooldown);
    }

    public int getShieldingDuration() {
        return (Integer)this.field_6011.method_12789(SHIELDING_DURATION);
    }

    public void setShieldingDuration(int shieldingDuration) {
        this.field_6011.method_12778(SHIELDING_DURATION, (Object)shieldingDuration);
    }

    public class_1792 getShieldingRechargeItem() {
        return class_1802.field_8183;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (this.method_5805() && this.method_6032() <= this.method_6063() / 4.0f && this.canShield() && !world.method_8608()) {
            this.startShielding();
        } else if (this.method_5805() && this.getShieldingDuration() <= 0 && !world.method_8608()) {
            this.setShielding(false);
        }
        if (this.isShielding() && world.field_9236 && !this.method_29504()) {
            class_243 entityPos = this.method_19538();
            Random random = new Random();
            int numberOfParticles = 10;
            ++this.fireSoundTicker;
            ++this.fireChargeSoundTicker;
            if (this.fireSoundTicker >= 20) {
                world.method_8486(entityPos.method_10216() + 0.5, entityPos.method_10214() + 0.5, entityPos.method_10215() + 0.5, class_3417.field_14993, class_3419.field_15254, 0.5f + random.nextFloat(), 0.0125f, false);
                this.fireSoundTicker = 0;
            }
            if (this.fireChargeSoundTicker >= 20) {
                world.method_8486(entityPos.method_10216() + 0.5, entityPos.method_10214() + 0.5, entityPos.method_10215() + 0.5, class_3417.field_15013, class_3419.field_15254, 0.5f + random.nextFloat(), 0.25f, false);
                this.fireChargeSoundTicker = 0;
            }
            for (int i = 0; i < numberOfParticles; ++i) {
                double velocityX = (random.nextDouble() - 0.5) * 0.4;
                double velocityY = (random.nextDouble() - 0.5) * 0.4;
                double velocityZ = (random.nextDouble() - 0.5) * 0.4;
                world.method_8406((class_2394)(random.nextBoolean() ? class_2398.field_11240 : class_2398.field_27783), entityPos.field_1352, entityPos.field_1351 + 1.0, entityPos.field_1350, velocityX, velocityY, velocityZ);
            }
        }
        if (this.isShielding() && !world.method_8608() && !this.method_29504()) {
            if (this.method_5721()) {
                this.setShielding(false);
            }
            this.setShieldingDuration(this.getShieldingDuration() - 1);
            class_238 area = new class_238(this.method_24515()).method_1009(3.0, 1.0, 3.0);
            List nearbyEntities = world.method_8390(class_1309.class, area, e -> true);
            if (nearbyEntities != null) {
                for (class_1309 entity : nearbyEntities) {
                    entity.method_33572(true);
                    entity.method_20803(100);
                    if (!(entity instanceof class_1657)) continue;
                    class_1657 player = (class_1657)entity;
                    if (!(world instanceof class_3218)) continue;
                    class_3218 serverWorld = (class_3218)world;
                    ModUtil.grantImpossibleAdvancement("bestiary/hot_hot_hot", serverWorld, player);
                }
            }
            this.meltNearbyBlocks(world);
        }
        if (!world.method_8608() && this.method_6032() < this.method_6063() && this.field_5974.method_43048(200) == 0 && this.method_37908().method_40134().method_40225(class_7134.field_37667) && this.method_5805()) {
            this.method_6033((int)(this.method_6032() + 1.0f));
        }
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    public boolean method_6510() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    public void method_19540(boolean attacking) {
        this.field_6011.method_12778(ATTACKING, (Object)attacking);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8814);
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5655() {
        return this.isShielding();
    }

    @Override
    public boolean isMoving() {
        return (Boolean)this.field_6011.method_12789(MOVING);
    }

    @Override
    public void setMoving(boolean moving) {
        this.field_6011.method_12778(MOVING, (Object)moving);
    }

    public boolean method_5810() {
        return !this.isShielding();
    }

    public boolean isShielding() {
        return (Boolean)this.field_6011.method_12789(SHIELDING);
    }

    public void setShielding(boolean shielding) {
        this.field_6011.method_12778(SHIELDING, (Object)shielding);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setShielding(nbt.method_10577("Shielding"));
        this.setShieldingDuration(nbt.method_10550("ShieldingDuration"));
        this.setShieldingCooldown(nbt.method_10550("ShieldingCooldown"));
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(0.0, x, z);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return ModSoundEvents.ENTITY_EMBER_TORTOISE_HURT.get();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            class_2338 newPos;
            class_2338 oldPos = this.method_24515();
            this.setMoving(oldPos != (newPos = this.method_24515()));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Shielding", this.isShielding());
        nbt.method_10569("ShieldingDuration", this.getShieldingDuration());
        nbt.method_10569("ShieldingCooldown", this.getShieldingCooldown());
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MOVING, (Object)false);
        builder.method_56912(ATTACKING, (Object)false);
        builder.method_56912(SHIELDING, (Object)false);
        builder.method_56912(SHIELDING_COOLDOWN, (Object)0);
        builder.method_56912(SHIELDING_DURATION, (Object)400);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new EmberTortoiseMeleeGoal((class_1314)this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new EmberTortoiseMateGoal(this, 1.2f));
        this.field_6201.method_6277(4, (class_1352)new EmberTortoiseTemptGoal(this, 1.2f, BREEDING_INGREDIENT, false));
        this.field_6201.method_6277(5, (class_1352)new EmberTortoiseFollowParentGoal(this, 1.2f));
        this.field_6201.method_6277(6, (class_1352)new EmberTortoiseWanderAroundFarGoal(this, 1.0, 0.001f));
        this.field_6201.method_6277(7, (class_1352)new EmberTortoiseLookAtEntityGoal(this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new EmberTortoiseLookAroundGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_4760.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_5136.class, true));
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f * 3.0f, 0.3f);
    }

    private void meltNearbyBlocks(class_1937 world) {
        class_2338 center = this.method_24515();
        int radius = 3;
        class_2338.method_20437((class_2338)center.method_10069(-radius, -radius, -radius), (class_2338)center.method_10069(radius + 1, radius, radius + 1)).filter(pos -> pos.method_19771((class_2382)center, (double)radius + 0.5)).forEach(pos -> {
            class_2680 state = world.method_8320(pos);
            class_2248 inputBlock = state.method_26204();
            class_1799 inputStack = new class_1799((class_1935)inputBlock.method_8389());
            Optional match = world.method_8433().method_8132(class_3956.field_17546, (class_9695)new class_9696(inputStack), world);
            if (match.isPresent()) {
                class_1799 result = ((class_3861)((class_8786)match.get()).comp_1933()).method_8110((class_7225.class_7874)world.method_30349());
                if (class_2248.method_9503((class_1792)result.method_7909()) != class_2246.field_10124) {
                    class_2248 resultBlock = class_2248.method_9503((class_1792)result.method_7909());
                    if (this.field_5974.method_43048(750) == 0) {
                        world.method_8501(pos, resultBlock.method_9564());
                    }
                }
            } else if (smeltableBlocksConversionMap.containsKey(inputBlock) && this.field_5974.method_43048(750) == 0) {
                world.method_8501(pos, smeltableBlocksConversionMap.get(inputBlock).method_9564());
            }
            if (this.field_5974.method_43048(2000) == 0 && world.method_8320(pos.method_10084()).method_26215() && state.method_26212((class_1922)world, pos)) {
                world.method_8501(pos.method_10084(), class_2246.field_10036.method_9564());
            }
        });
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.isMoving() && !this.isShielding()) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.method_6510() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 40;
            this.attackAnimationState.method_41322(this.field_6012);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.method_6510()) {
            this.attackAnimationState.method_41325();
        }
        if (this.isShielding() && this.shieldingAnimationTimeout <= 0) {
            this.shieldingAnimationState.method_41322(this.field_6012);
            this.shieldingTubeAnimationState.method_41324(this.field_6012);
            this.shieldingAnimationTimeout = 1;
        } else if (!this.isShielding()) {
            this.shieldingAnimationTimeout = 0;
        }
    }

    private void startShielding() {
        this.setShielding(true);
        this.setShieldingDuration((this.field_5974.method_39332(4, 8) + 1) * 100);
        this.setShieldingCooldown(2400);
    }

    static {
        smeltableBlocksConversionMap.put(class_2246.field_10219, class_2246.field_10566);
        smeltableBlocksConversionMap.put(class_2246.field_10520, class_2246.field_10566);
        smeltableBlocksConversionMap.put(class_2246.field_10402, class_2246.field_10566);
        smeltableBlocksConversionMap.put(class_2246.field_10295, class_2246.field_10382);
        smeltableBlocksConversionMap.put(class_2246.field_22120, class_2246.field_10515);
        smeltableBlocksConversionMap.put(class_2246.field_22113, class_2246.field_10515);
        smeltableBlocksConversionMap.put(class_2246.field_33508, class_2246.field_10085);
        smeltableBlocksConversionMap.put(class_2246.field_33509, class_2246.field_27119);
        smeltableBlocksConversionMap.put(class_2246.field_33510, class_2246.field_10205);
    }
}

