/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.MossbloomDropHornsGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.TrackedFleeGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.WanderAroundFarOftenGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.entity.variants.MossbloomVariant;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1316;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1752;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1856;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6026;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class MossbloomEntity
extends ParentTameableEntity
implements class_6026,
class_1316 {
    private static final class_2940<String> VARIANT = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> HAS_HORNS = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> HORN_DROP_TIMER = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TIME_TILL_DROP = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_SHAKING = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_SPRINTING = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_SADDLED = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13323);
    public static int SHOULD_DROP_HORNS_VALUE = 12000;
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 shakingAnimationState = new class_7094();
    public final class_7094 earTwitchAnimationStateLE = new class_7094();
    public final class_7094 earTwitchAnimationStateRE = new class_7094();
    public final class_7094 earTwitchAnimationStateBE = new class_7094();
    public final class_7094 wagTailAnimationStateBE = new class_7094();
    public int idleAnimationTimeout = 0;
    public int shakingAnimationTimeout = 0;
    public int earTwitchAnimationTimeout = 0;
    protected int soundTicks;
    protected boolean inAir;
    protected float jumpStrength;
    private final class_1792 tamingItem = class_1802.field_28652;

    public MossbloomEntity(class_1299<? extends ParentTameableEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return ParentAnimalEntity.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.15f).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23722, 0.5).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23728, 0.75).method_26868(class_5134.field_47761, 1.0);
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModBlockTags.MOSSBLOOMS_SPAWN_ON);
    }

    public void method_24650(class_3218 world, class_1429 other) {
        MossbloomEntity child = (MossbloomEntity)this.method_5613(world, (class_1296)other);
        if (child != null) {
            class_3222 serverPlayerEntity = this.method_6478();
            if (serverPlayerEntity == null && other.method_6478() != null) {
                serverPlayerEntity = other.method_6478();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.method_7281(class_3468.field_15410);
                class_174.field_1190.method_855(serverPlayerEntity, (class_1429)this, other, (class_1296)child);
            }
            this.method_5614(6000);
            other.method_5614(6000);
            this.method_6477();
            other.method_6477();
            child.method_7217(true);
            boolean isVariantHorned = this.field_5974.method_43056();
            child.setVariant(isVariantHorned ? MossbloomVariant.HORNED : MossbloomVariant.FLOWERING);
            child.setHasHorns(isVariantHorned);
            if (isVariantHorned) {
                child.setHornDropTimer(-SHOULD_DROP_HORNS_VALUE);
            }
            child.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, 0.0f);
            world.method_30771((class_1297)child);
            world.method_8421((class_1297)this, (byte)18);
            if (world.method_8450().method_8355(class_1928.field_19391)) {
                world.method_8649((class_1297)new class_1303((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), this.method_59922().method_43048(7) + 1));
            }
        }
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (!state.method_51176()) {
            class_2680 blockState = this.method_37908().method_8320(pos.method_10084());
            class_2498 blockSoundGroup = state.method_26231();
            if (blockState.method_27852(class_2246.field_10477)) {
                blockSoundGroup = blockState.method_26231();
            }
            if (this.method_5782()) {
                ++this.soundTicks;
                if (this.soundTicks > 5 && this.soundTicks % 3 == 0) {
                    this.playWalkSound(blockSoundGroup);
                } else if (this.soundTicks <= 5) {
                    this.method_5783(class_3417.field_15061, blockSoundGroup.method_10597() * 0.15f, blockSoundGroup.method_10599() + 0.5f);
                }
            } else if (this.isWooden(blockSoundGroup)) {
                this.method_5783(class_3417.field_15061, blockSoundGroup.method_10597() * 0.15f, blockSoundGroup.method_10599() + 0.5f);
            } else {
                this.method_5783(class_3417.field_14613, blockSoundGroup.method_10597() * 0.15f, blockSoundGroup.method_10599() + 0.5f);
            }
        }
    }

    protected void playWalkSound(class_2498 group) {
        this.method_5783(class_3417.field_14987, group.method_10597() * 0.05f, group.method_10599() + 0.25f);
        if (this.field_5974.method_43048(10) == 0) {
            this.method_5783(class_3417.field_14556, group.method_10597() * 0.6f, group.method_10599() + 0.5f);
        }
    }

    private boolean isWooden(class_2498 soundGroup) {
        return soundGroup == class_2498.field_11547 || soundGroup == class_2498.field_40315 || soundGroup == class_2498.field_22152 || soundGroup == class_2498.field_42766 || soundGroup == class_2498.field_40314;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        int i;
        if (fallDistance > 1.0f) {
            this.method_5783(class_3417.field_14783, 0.4f, 1.75f);
        }
        if ((i = this.method_23329(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.method_5643(damageSource, i);
        if (this.method_5782()) {
            for (class_1297 entity : this.method_5736()) {
                entity.method_5643(damageSource, (float)i);
            }
        }
        this.method_23328();
        return true;
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return class_3532.method_15386((float)((fallDistance * 0.5f - 3.0f) * damageMultiplier));
    }

    public boolean method_6474(class_1429 other) {
        if (other == this) {
            return false;
        }
        if (other.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (((MossbloomEntity)other).getVariant().getId().equals(this.getVariant().getId())) {
            return false;
        }
        return this.method_6479() && other.method_6479();
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        class_2338 pos = this.method_24515();
        class_2680 blockState = world.method_8320(pos.method_10074());
        return blockState.method_27852(class_2246.field_10219) || blockState.method_27852(class_2246.field_10340) || blockState.method_27852(class_2246.field_28681) || blockState.method_27852(class_2246.field_10460);
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        MossbloomEntity child = (MossbloomEntity)((class_1299)ModEntityTypes.MOSSBLOOM.get()).method_5883((class_1937)world);
        if (child != null) {
            child.setVariant(MossbloomVariant.getRandom());
        }
        return child;
    }

    public boolean getHasHorns() {
        return (Boolean)this.field_6011.method_12789(HAS_HORNS);
    }

    public void setHasHorns(boolean hasHorns) {
        this.field_6011.method_12778(HAS_HORNS, (Object)hasHorns);
    }

    public int getHornDropTimer() {
        return (Integer)this.field_6011.method_12789(HORN_DROP_TIMER);
    }

    public void setHornDropTimer(int hornDropTimer) {
        this.field_6011.method_12778(HORN_DROP_TIMER, (Object)hornDropTimer);
    }

    public boolean getIsShaking() {
        return (Boolean)this.field_6011.method_12789(IS_SHAKING);
    }

    public void setIsShaking(boolean isShaking) {
        this.field_6011.method_12778(IS_SHAKING, (Object)isShaking);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return ModSoundEvents.ENTITY_MOSSBLOOM_HURT.get();
    }

    public int method_5945() {
        return 2;
    }

    public int getTimeTillDrop() {
        return (Integer)this.field_6011.method_12789(TIME_TILL_DROP);
    }

    public void method_6154(int strength) {
        if (this.getIsSaddled()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.field_6282 = true;
            }
            this.jumpStrength = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, movementInput);
        class_241 vec2f = this.getControlledRotation((class_1309)controllingPlayer);
        this.method_5710(vec2f.field_1342, vec2f.field_1343);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        if (this.method_5787() && this.method_24828()) {
            this.setInAir(false);
            if (this.jumpStrength > 0.0f && !this.isInAir()) {
                this.jump(this.jumpStrength, movementInput);
            }
            this.jumpStrength = 0.0f;
        }
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        if (this.method_24828() && this.jumpStrength == 0.0f && !this.field_6282) {
            return class_243.field_1353;
        }
        float f = controllingPlayer.field_6212 * 0.5f;
        float g = controllingPlayer.field_6250;
        if (g <= 0.0f) {
            g *= 0.25f;
        }
        return new class_243((double)f, 0.0, (double)g);
    }

    protected void jump(float strength, class_243 movementInput) {
        double d = this.getJumpStrength() * (double)strength * (double)this.method_23313();
        double e = d + (double)this.method_37416();
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, e, vec3d.field_1350);
        this.setInAir(true);
        this.field_6007 = true;
        if (movementInput.field_1350 > 0.0) {
            float f = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
            float g = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
            this.method_18799(this.method_18798().method_1031((double)(-0.4f * f * strength), 0.0, (double)(0.4f * g * strength)));
        }
    }

    public double getJumpStrength() {
        return this.method_45325(class_5134.field_23728);
    }

    public boolean isInAir() {
        return this.inAir;
    }

    public void setInAir(boolean inAir) {
        this.inAir = inAir;
    }

    protected class_241 getControlledRotation(class_1309 controllingPassenger) {
        return new class_241(controllingPassenger.method_36455() * 0.5f, controllingPassenger.method_36454());
    }

    public boolean method_6153() {
        return this.getIsSaddled();
    }

    public void method_6155(int height) {
        this.field_6282 = true;
    }

    public void method_6156() {
    }

    public void setTimeTillDrop(int timeTillDrop) {
        this.field_6011.method_12778(TIME_TILL_DROP, (Object)timeTillDrop);
    }

    public boolean getSprinting() {
        return (Boolean)this.field_6011.method_12789(IS_SPRINTING);
    }

    public void setIsSprinting(boolean sprinting) {
        this.field_6011.method_12778(IS_SPRINTING, (Object)sprinting);
    }

    public boolean getIsSaddled() {
        return (Boolean)this.field_6011.method_12789(IS_SADDLED);
    }

    public void setIsSaddled(boolean saddled) {
        this.field_6011.method_12778(IS_SADDLED, (Object)saddled);
    }

    public String getTypeVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public MossbloomVariant getVariant() {
        return MossbloomVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(MossbloomVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        MossbloomVariant variant = MossbloomVariant.getRandom();
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_28657);
    }

    public boolean isVariantOf(MossbloomVariant variant) {
        return this.getVariant() == variant;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10558("Variant"));
        this.field_6011.method_12778(HAS_HORNS, (Object)nbt.method_10577("HasHorns"));
        this.field_6011.method_12778(HORN_DROP_TIMER, (Object)nbt.method_10550("HornDropTimer"));
        this.field_6011.method_12778(IS_SHAKING, (Object)nbt.method_10577("IsShaking"));
        this.field_6011.method_12778(IS_SADDLED, (Object)nbt.method_10577("IsSaddled"));
    }

    public boolean method_6062() {
        return super.method_6062() && this.method_5782() && this.getIsSaddled();
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (this.getVariant() == MossbloomVariant.FLOWERING && this.method_59922().method_43048(4800) == 0) {
            this.tickFertilize(world);
        }
        if (world.field_9236) {
            this.setupAnimationStates();
        }
        if (this.getVariant() == MossbloomVariant.HORNED && !this.method_6109()) {
            if (this.getHornDropTimer() >= SHOULD_DROP_HORNS_VALUE / 3) {
                this.setHasHorns(true);
            }
            this.setHornDropTimer(this.getHornDropTimer() + this.field_5974.method_43048(1) + 1);
        }
        if (this.getVariant() == MossbloomVariant.HORNED && this.method_6109()) {
            this.setHasHorns(false);
        }
        this.field_6282 = false;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.method_6181() && hand == class_1268.field_5808) {
            if (!player.method_5715()) {
                if (!this.getIsSaddled() && itemStack.method_31574(class_1802.field_8175)) {
                    if (!player.method_31549().field_7477) {
                        itemStack.method_7934(1);
                    }
                    this.setIsSaddled(true);
                    this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14824, class_3419.field_15254, 0.5f, 1.25f);
                    return class_1269.field_5812;
                }
                if (itemStack.method_7960()) {
                    this.setRiding(player);
                    return class_1269.field_5812;
                }
            }
            if (item instanceof class_1820) {
                this.setIsSaddled(false);
                itemStack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                this.method_5699(new class_1799((class_1935)class_1802.field_8175), 0.5f);
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14705, class_3419.field_15254, 0.5f, 1.25f);
                return class_1269.field_5812;
            }
        }
        if (!this.method_6181() && item == this.tamingItem) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15099, class_3419.field_15254, 0.5f, 1.75f);
            if (this.field_5974.method_43048(8) == 0) {
                super.method_6170(player);
                this.field_6189.method_6356();
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.method_5869() && this.method_5642() != null) {
            this.method_5642().method_29239();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Variant", this.getTypeVariant());
        nbt.method_10556("HasHorns", this.getHasHorns());
        nbt.method_10569("HornDropTimer", this.getHornDropTimer());
        nbt.method_10556("IsShaking", this.getIsShaking());
        nbt.method_10556("IsSaddled", this.getIsSaddled());
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)MossbloomVariant.HORNED.getId());
        builder.method_56912(HAS_HORNS, (Object)true);
        builder.method_56912(HORN_DROP_TIMER, (Object)0);
        builder.method_56912(IS_SHAKING, (Object)false);
        builder.method_56912(TIME_TILL_DROP, (Object)0);
        builder.method_56912(IS_SPRINTING, (Object)false);
        builder.method_56912(IS_SADDLED, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new MossbloomDropHornsGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new TrackedFleeGoal(this, 2.5));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.25, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_28657}), false));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new WanderAroundFarOftenGoal((class_1314)this, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5619() {
        super.method_5619();
        if (!this.method_6109() && this.getVariant() == MossbloomVariant.HORNED) {
            this.setHasHorns(true);
        }
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f * 1.5f, 0.5f);
    }

    private void pickRandomIdleAnim(int i) {
        switch (i) {
            case 1: {
                this.earTwitchAnimationStateRE.method_41324(this.field_6012);
                break;
            }
            case 2: {
                this.earTwitchAnimationStateLE.method_41324(this.field_6012);
                break;
            }
            case 3: {
                this.wagTailAnimationStateBE.method_41324(this.field_6012);
                break;
            }
            default: {
                this.earTwitchAnimationStateBE.method_41324(this.field_6012);
            }
        }
    }

    private void setupAnimationStates() {
        if (this.shakingAnimationTimeout <= 0 && this.getIsShaking()) {
            this.shakingAnimationTimeout = 60;
            this.shakingAnimationState.method_41322(this.field_6012);
        } else {
            --this.shakingAnimationTimeout;
        }
        if (this.idleAnimationTimeout <= 0 && !this.isMoving()) {
            this.idleAnimationTimeout = 10;
            this.idleAnimationState.method_41324(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.earTwitchAnimationTimeout <= 0 && this.field_5974.method_43048(50) == 0) {
            this.earTwitchAnimationTimeout = 5;
            this.pickRandomIdleAnim(this.field_5974.method_43048(4));
        } else {
            --this.earTwitchAnimationTimeout;
        }
    }

    private void tickFertilize(class_1937 world) {
        class_2338 origin = this.method_24515();
        int ox = origin.method_10263();
        int oy = origin.method_10264();
        int oz = origin.method_10260();
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_5819 rand = this.method_59922();
        int dyStart = rand.method_43048(3);
        int dyStep = rand.method_43056() ? 1 : 2;
        int dxStart = rand.method_43048(11);
        int dxStep = rand.method_43048(10) + 1;
        int dzStart = rand.method_43048(11);
        int dzStep = rand.method_43048(10) + 1;
        int maxChecks = 32;
        block0: for (int yi = 0; yi < 3; ++yi) {
            int dy = (dyStart + yi * dyStep) % 3 - 1;
            for (int xi = 0; xi < 11; ++xi) {
                int dx = (dxStart + xi * dxStep) % 11 - 5;
                for (int zi = 0; zi < 11; ++zi) {
                    class_2256 fertilizable;
                    if (--maxChecks < 0) break block0;
                    int dz = (dzStart + zi * dzStep) % 11 - 5;
                    pos.method_10103(ox + dx, oy + dy, oz + dz);
                    class_2680 state = world.method_8320((class_2338)pos);
                    if (state.method_26215()) continue;
                    class_2248 block = state.method_26204();
                    if (!state.method_26164(class_3481.field_20342) || !(block instanceof class_2256) || !(fertilizable = (class_2256)block).method_9651((class_4538)world, (class_2338)pos, state) || !fertilizable.method_9650(world, rand, (class_2338)pos, state)) continue;
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        fertilizable.method_9652(serverWorld, rand, (class_2338)pos, state);
                        break block0;
                    }
                    class_1752.method_7721((class_1936)world, (class_2338)pos, (int)15);
                    break block0;
                }
            }
        }
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 firstPassenger = this.method_31483();
        if (firstPassenger instanceof class_1308) {
            class_1308 mobEntity = (class_1308)firstPassenger;
            return mobEntity;
        }
        if (this.getIsSaddled() && (firstPassenger = this.method_31483()) instanceof class_1657) {
            return (class_1657)firstPassenger;
        }
        return null;
    }

    private void setRiding(class_1657 pPlayer) {
        pPlayer.method_36456(this.method_36454());
        pPlayer.method_36457(this.method_36455());
        pPlayer.method_5804((class_1297)this);
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5782() && this.method_5642() instanceof class_1657) {
            class_1309 livingentity = this.method_5642();
            this.method_36456(livingentity.method_36454());
            this.field_5982 = this.method_36454();
            this.method_36457(livingentity.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.field_6241 = this.field_6283 = this.method_36454();
            float f = livingentity.field_6212 * 0.5f;
            float f1 = livingentity.field_6250;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            if (this.method_5787()) {
                float newSpeed = (float)this.method_45325(class_5134.field_23719);
                boolean sprinting = class_310.method_1551().field_1690.field_1867.method_1434();
                if (sprinting) {
                    newSpeed *= 1.4f;
                }
                this.setIsSprinting(sprinting);
                this.method_6125(newSpeed);
                super.method_6091(new class_243((double)f, movementInput.field_1351, (double)f1));
            }
        } else {
            super.method_6091(movementInput);
        }
    }

    public class_243 method_24829(class_1309 passenger) {
        class_2350 direction = this.method_5755();
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return super.method_24829(passenger);
        }
        int[][] is = class_5275.method_27934((class_2350)direction);
        class_2338 blockPos = this.method_24515();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_4050 entityPose : passenger.method_24831()) {
            class_238 box = passenger.method_24833(entityPose);
            for (int[] js : is) {
                mutable.method_10103(blockPos.method_10263() + js[0], blockPos.method_10264(), blockPos.method_10260() + js[1]);
                double d = this.method_37908().method_30347((class_2338)mutable);
                if (!class_5275.method_27932((double)d)) continue;
                class_243 vec3d = class_243.method_26410((class_2382)mutable, (double)d);
                if (!class_5275.method_27933((class_1941)this.method_37908(), (class_1309)passenger, (class_238)box.method_997(vec3d))) continue;
                passenger.method_18380(entityPose);
                return vec3d;
            }
        }
        return super.method_24829(passenger);
    }
}

