/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.PotionSacEntity;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.variants.PotionWaspVariant;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class PotionWaspEntity
extends ParentAnimalEntity {
    private static final class_2940<String> VARIANT = class_2945.method_12791(PotionWaspEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> HAS_POTION_SAC = class_2945.method_12791(PotionWaspEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 flyingAnimState = new class_7094();
    private int animationTimeout = 0;

    public PotionWaspEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.field_6206 = new PotionWaspLookControl((class_1308)this);
    }

    public boolean method_6049(class_1293 effectInstance) {
        List<class_6880<class_1291>> potionEffects = PotionWaspVariant.getAllStatusEffects();
        for (class_6880<class_1291> effect : potionEffects) {
            if (effectInstance.method_5579() != effect) continue;
            return false;
        }
        return true;
    }

    public static class_5132.class_5133 setAttributes() {
        return ParentAnimalEntity.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, 0.5).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23717, 16.0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        PotionWaspVariant variant = PotionWaspVariant.getRandom();
        this.setVariant(variant);
        this.setHasPotionSac(true);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1937 class_19372;
        if (this.hasPotionSac() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PotionSacEntity potionSacEntity = (PotionSacEntity)((class_1299)ModEntityTypes.POTION_SAC.get()).method_5883((class_1937)serverWorld);
            if (potionSacEntity == null) {
                return super.method_5643(source, amount);
            }
            potionSacEntity.setVariant(this.getVariant());
            potionSacEntity.method_33574(this.method_19538().method_1031(0.0, -0.25, 0.0));
            potionSacEntity.method_24830(false);
            serverWorld.method_8649((class_1297)potionSacEntity);
            this.setHasPotionSac(false);
        }
        return super.method_5643(source, amount);
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return world.method_8320(pos).method_26215() ? 10.0f : 0.0f;
    }

    public String getTypeVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public PotionWaspVariant getVariant() {
        return PotionWaspVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(PotionWaspVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean hasPotionSac() {
        return (Boolean)this.field_6011.method_12789(HAS_POTION_SAC);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10558("Variant"));
        this.field_6011.method_12778(HAS_POTION_SAC, (Object)nbt.method_10577("HasPotionSac"));
    }

    public void setHasPotionSac(boolean hasPotionSac) {
        this.field_6011.method_12778(HAS_POTION_SAC, (Object)hasPotionSac);
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(this.hasPotionSac() ? 0.0 : strength, x, z);
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Variant", this.getTypeVariant());
        nbt.method_10556("HasPotionSac", this.hasPotionSac());
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModBlockTags.POTION_WASPS_SPAWN_ON);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407(this, (class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    @Nullable
    protected class_3414 method_5994() {
        return null;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)PotionWaspVariant.REGENERATION.getId());
        builder.method_56912(HAS_POTION_SAC, (Object)true);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new PotionWaspWanderAroundGoal(this));
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 40;
            this.flyingAnimState.method_41322(this.field_6012);
        } else {
            --this.animationTimeout;
        }
    }

    static class PotionWaspLookControl
    extends class_1333 {
        PotionWaspLookControl(class_1308 entity) {
            super(entity);
        }

        public void method_6231() {
            super.method_6231();
        }

        protected boolean method_20433() {
            return true;
        }
    }

    class PotionWaspWanderAroundGoal
    extends class_1352 {
        PotionWaspWanderAroundGoal(PotionWaspEntity potionWasp) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return PotionWaspEntity.this.field_6189.method_6357() && PotionWaspEntity.this.field_5974.method_43048(4) == 0;
        }

        public boolean method_6266() {
            return PotionWaspEntity.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                PotionWaspEntity.this.field_6189.method_6334(PotionWaspEntity.this.field_6189.method_6348(class_2338.method_49638((class_2374)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private class_243 getRandomLocation() {
            class_243 vec3d2 = PotionWaspEntity.this.method_5828(0.0f);
            class_243 vec3d3 = class_5533.method_31524((class_1314)PotionWaspEntity.this, (int)8, (int)7, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : class_5530.method_31504((class_1314)PotionWaspEntity.this, (int)8, (int)4, (int)-2, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (double)1.5707963705062866);
        }
    }
}

