/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2960;

public enum ButterflyVariant {
    WHITE("white", class_124.field_1068, 0),
    LIGHT_GRAY("light_gray", class_124.field_1080, 1),
    GRAY("gray", class_124.field_1063, 2),
    BLACK("black", class_124.field_1074, 3),
    BROWN("brown", class_124.field_1065, 4),
    RED("red", class_124.field_1079, 5),
    ORANGE("orange", class_124.field_1065, 6),
    YELLOW("yellow", class_124.field_1054, 7),
    LIME("lime", class_124.field_1060, 8),
    GREEN("green", class_124.field_1077, 9),
    LIGHT_BLUE("light_blue", class_124.field_1078, 10),
    CYAN("cyan", class_124.field_1062, 11),
    BLUE("blue", class_124.field_1058, 12),
    PURPLE("purple", class_124.field_1064, 13),
    MAGENTA("magenta", class_124.field_1076, 14),
    PINK("pink", class_124.field_1061, 15),
    WARPED("warped", class_124.field_1062, 16, true),
    CRIMSON("crimson", class_124.field_1079, 17, true),
    SOUL("soul", class_124.field_1065, 18, true);

    private final String name;
    private final class_124 colorFormatting;
    private final boolean isFireImmune;
    private static final Map<class_2960, ButterflyVariant> BY_ID;
    public static final Codec<ButterflyVariant> CODEC;
    private final int ID;

    private ButterflyVariant(String name, class_124 colorFormatting, int ID, boolean isFireImmune) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.isFireImmune = isFireImmune;
        this.ID = ID;
    }

    private ButterflyVariant(String name, class_124 colorFormatting, int ID) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.isFireImmune = false;
        this.ID = ID;
    }

    public static ButterflyVariant fromId(String id) {
        return Arrays.stream(ButterflyVariant.values()).filter(v -> v.getId().equals(id)).findFirst().orElse(WHITE);
    }

    public static ButterflyVariant getRandom(boolean overworldOnly) {
        List<ButterflyVariant> filtered = Arrays.stream(ButterflyVariant.values()).filter(v -> !overworldOnly || !v.isFireImmune()).toList();
        return filtered.get(new Random().nextInt(filtered.size()));
    }

    public class_124 getColorFormatting() {
        return this.colorFormatting;
    }

    public String getId() {
        return "clutterbestiary:" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getTextureLocation() {
        return class_2960.method_60655((String)"clutterbestiary", (String)("textures/entity/butterfly/" + this.getName() + "_butterfly.png"));
    }

    public boolean isFireImmune() {
        return this.isFireImmune;
    }

    public int getOrderedID() {
        return this.ID;
    }

    static {
        BY_ID = Arrays.stream(ButterflyVariant.values()).collect(Collectors.toMap(v -> class_2960.method_60655((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = class_2960.field_25139.comapFlatMap(id -> {
            ButterflyVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)((Object)v)) : DataResult.error(() -> "Unknown butterfly variant: " + String.valueOf(id));
        }, v -> class_2960.method_60655((String)"clutterbestiary", (String)v.getName()));
    }
}

