/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants.koi;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.variants.BestiaryBasicVariant;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public enum KoiBaseColorVariant implements BestiaryBasicVariant
{
    ORANGE("orange", class_124.field_1065, 16737302, 100, false),
    YELLOW("yellow", class_124.field_1054, 15718512, 100, false),
    BLACK("black", class_124.field_1063, 4080969, 100, false),
    WHITE("white", class_124.field_1068, 0xEAEAFF, 100, false),
    IRIDESCENT_WHITE("iridescent_white", class_124.field_1068, new int[]{0xF9FCFF, 0xFBEBFB, 15066111, 13755903, 12900863, 10735103}, 2, true),
    IRIDESCENT_BLUE("iridescent_blue", class_124.field_1075, new int[]{0xF7FCFF, 15593727, 14018815, 12839423, 11460607, 9886207}, 2, true),
    IRIDESCENT_PINK("iridescent_pink", class_124.field_1076, new int[]{0xFEF7FF, 0xFBEBFB, 16506871, 16440053, 16239851, 16105446}, 2, true),
    IRIDESCENT_PURPLE("iridescent_purple", class_124.field_1064, new int[]{0xFAF8FF, 15919615, 0xDDD8FF, 14144255, 13552639, 0xBBBCFF}, 2, true),
    IRIDESCENT_RAINBOW("iridescent_rainbow", class_124.field_1068, new int[]{0xFF0000, 16753920, 0xFFFF00, 32768, 255, 4915330, 9109759}, 1, true),
    PEARL("pearl", class_124.field_1062, new int[]{0xFFFFFF, 14413033, 13817046, 13415096, 9090761, 7839686}, 1, true);

    private static final Map<class_2960, KoiBaseColorVariant> BY_ID;
    public static final Codec<KoiBaseColorVariant> CODEC;
    private final String name;
    private final class_124 formatting;
    private final int[] colorHex;
    private final int weight;
    private final boolean separateTexture;

    private KoiBaseColorVariant(String name, class_124 formatting, int colorHex, int weight, boolean separateTexture) {
        this.name = name;
        this.formatting = formatting;
        this.colorHex = new int[]{colorHex};
        this.weight = weight;
        this.separateTexture = separateTexture;
    }

    private KoiBaseColorVariant(String name, class_124 formatting, int[] colorHexArray, int weight, boolean separateTexture) {
        this.name = name;
        this.formatting = formatting;
        this.colorHex = colorHexArray;
        this.weight = weight;
        this.separateTexture = separateTexture;
    }

    public static KoiBaseColorVariant fromId(String id) {
        return Arrays.stream(KoiBaseColorVariant.values()).filter(v -> v.getID().equals(id)).findFirst().orElse(ORANGE);
    }

    public static KoiBaseColorVariant getRandom() {
        Random random = new Random();
        int totalWeight = Arrays.stream(KoiBaseColorVariant.values()).mapToInt(KoiBaseColorVariant::getWeight).sum();
        int roll = random.nextInt(totalWeight);
        int cumulative = 0;
        for (KoiBaseColorVariant variant : KoiBaseColorVariant.values()) {
            if (roll >= (cumulative += variant.getWeight())) continue;
            return variant;
        }
        return ORANGE;
    }

    @Override
    public String getID() {
        return "clutterbestiary:" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public class_124 getFormatting() {
        return this.formatting;
    }

    public boolean hasSeparateTexture() {
        return this.separateTexture;
    }

    public int[] getColorHex() {
        return this.colorHex;
    }

    public int getWeight() {
        return this.weight;
    }

    public class_2960 getTextureLocation() {
        return this.hasSeparateTexture() ? class_2960.method_60655((String)"clutterbestiary", (String)("textures/entity/koi/koi_" + this.getName() + ".png")) : class_2960.method_60655((String)"clutterbestiary", (String)"textures/entity/koi/koi_base.png");
    }

    @Nullable
    public static class_2960 getEmissiveTextureFromEntity(KoiEntity koiEntity) {
        return koiEntity.getBaseColorVariant().hasSeparateTexture() ? class_2960.method_60655((String)"clutterbestiary", (String)("textures/entity/koi/koi_" + koiEntity.getBaseColorVariant().getName() + "_emissive.png")) : null;
    }

    static {
        BY_ID = Arrays.stream(KoiBaseColorVariant.values()).collect(Collectors.toMap(v -> class_2960.method_60655((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = class_2960.field_25139.comapFlatMap(id -> {
            KoiBaseColorVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)v) : DataResult.error(() -> "Unknown koi base color: " + String.valueOf(id));
        }, v -> class_2960.method_60655((String)"clutterbestiary", (String)v.getName()));
    }
}

