/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.fabric.util;

import java.util.Optional;
import net.emilsg.clutterbestiary.entity.variants.ButterflyVariant;
import net.emilsg.clutterbestiary.entity.variants.SeahorseVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.item.custom.BestiaryElytraItem;
import net.emilsg.clutterbestiary.item.custom.ButterflyBottleItem;
import net.emilsg.clutterbestiary.item.custom.KoiBucketItem;
import net.emilsg.clutterbestiary.item.custom.SeahorseBucketItem;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ModModelPredicateProvider {
    public static void register() {
        for (class_1792 item : class_7923.field_41178) {
            if (item instanceof BestiaryElytraItem) {
                ModModelPredicateProvider.registerElytra(item);
            }
            if (item instanceof ButterflyBottleItem) {
                ModModelPredicateProvider.registerButterflyInABottle(item);
            }
            if (item instanceof SeahorseBucketItem) {
                ModModelPredicateProvider.registerSeahorseBucket(item);
            }
            if (!(item instanceof KoiBucketItem)) continue;
            ModModelPredicateProvider.registerKoiBucket(item);
        }
    }

    private static void registerElytra(class_1792 elytra) {
        class_5272.method_27879((class_1792)elytra, (class_2960)class_2960.method_60655((String)"minecraft", (String)"broken"), (stack, world, entity, seed) -> {
            class_1792 patt0$temp = stack.method_7909();
            if (!(patt0$temp instanceof BestiaryElytraItem)) {
                return 0.0f;
            }
            BestiaryElytraItem bestiaryElytraItem = (BestiaryElytraItem)patt0$temp;
            return bestiaryElytraItem.isBroken(stack) ? 1.0f : 0.0f;
        });
    }

    private static void registerButterflyInABottle(class_1792 bottle) {
        class_5272.method_27879((class_1792)bottle, (class_2960)class_2960.method_60654((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof ButterflyBottleItem)) {
                return 0.0f;
            }
            class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
            Optional optional = nbtComponent.method_57446(ButterflyBottleItem.BUTTERFLY_VARIANT_MAP_CODEC).result();
            if (optional.isEmpty()) {
                return 0.0f;
            }
            int id = ((ButterflyVariant)((Object)((Object)optional.get()))).getOrderedID();
            return (float)id / 100.0f;
        });
    }

    private static void registerSeahorseBucket(class_1792 bucket) {
        class_5272.method_27879((class_1792)bucket, (class_2960)class_2960.method_60654((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof SeahorseBucketItem)) {
                return 0.0f;
            }
            class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
            Optional optional = nbtComponent.method_57446(SeahorseBucketItem.SEAHORSE_VARIANT_MAP_CODEC).result();
            if (optional.isEmpty()) {
                return 0.0f;
            }
            SeahorseVariant seahorseVariant = (SeahorseVariant)((Object)((Object)optional.get()));
            float type = switch (seahorseVariant) {
                case SeahorseVariant.LIGHT_BLUE -> 0.1f;
                case SeahorseVariant.RED -> 0.2f;
                case SeahorseVariant.PURPLE -> 0.3f;
                default -> 0.0f;
            };
            return type;
        });
    }

    private static void registerKoiBucket(class_1792 bucket) {
        class_5272.method_27879((class_1792)bucket, (class_2960)class_2960.method_60654((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof KoiBucketItem)) {
                return 0.0f;
            }
            class_9279 cmp = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
            Optional base = cmp.method_57446(KoiBucketItem.BASE_COLOR_CODEC).result();
            if (base.isEmpty()) {
                return 0.0f;
            }
            return switch ((KoiBaseColorVariant)base.get()) {
                case KoiBaseColorVariant.ORANGE -> 0.1f;
                case KoiBaseColorVariant.YELLOW -> 0.2f;
                case KoiBaseColorVariant.BLACK -> 0.3f;
                case KoiBaseColorVariant.PEARL -> 0.4f;
                default -> 0.0f;
            };
        });
    }
}

