/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.item.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternTypeVariant;
import net.emilsg.clutterbestiary.util.ModUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_5244;
import net.minecraft.class_5712;
import net.minecraft.class_5761;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class KoiBucketItem
extends class_1785 {
    public static final MapCodec<KoiBaseColorVariant> BASE_COLOR_CODEC = KoiBaseColorVariant.CODEC.fieldOf("BaseColor");
    public static final MapCodec<KoiPrimaryPatternTypeVariant> PRIMARY_TYPE_CODEC = KoiPrimaryPatternTypeVariant.CODEC.fieldOf("PrimaryPatternType");
    public static final MapCodec<KoiPrimaryPatternColorVariant> PRIMARY_COLOR_CODEC = KoiPrimaryPatternColorVariant.CODEC.fieldOf("PrimaryPatternColor");
    public static final MapCodec<KoiSecondaryPatternTypeVariant> SECONDARY_TYPE_CODEC = KoiSecondaryPatternTypeVariant.CODEC.fieldOf("SecondaryPatternType");
    public static final MapCodec<KoiSecondaryPatternColorVariant> SECONDARY_COLOR_CODEC = KoiSecondaryPatternColorVariant.CODEC.fieldOf("SecondaryPatternColor");
    private final Supplier<? extends class_1299<?>> type;

    public KoiBucketItem(Supplier<? extends class_1299<?>> type, class_3611 fluid, class_3414 emptyingSound, class_1792.class_1793 settings) {
        super(null, fluid, emptyingSound, settings);
        this.type = type;
    }

    public void method_7728(@Nullable class_1657 player, class_1937 world, class_1799 stack, class_2338 pos) {
        if (world instanceof class_3218) {
            this.spawnEntity((class_3218)world, stack, pos);
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28738, pos);
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 ctx, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, ctx, tooltip, type);
        class_9279 cmp = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
        Optional baseOpt = cmp.method_57446(BASE_COLOR_CODEC).result();
        if (baseOpt.isEmpty()) {
            return;
        }
        KoiBaseColorVariant base = (KoiBaseColorVariant)baseOpt.get();
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.clutterbestiary.base_color.koi").method_27692(class_124.field_1080));
        if (base.hasSeparateTexture()) {
            int tick = (int)(System.currentTimeMillis() / 100L) % base.getColorHex().length;
            tooltip.add(ModUtil.buildCyclicFormattedName("tooltip.clutterbestiary." + base.getName() + ".koi", base.getColorHex(), tick, true));
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.clutterbestiary." + base.getName() + ".koi")).method_27692(base.getFormatting()));
        KoiPrimaryPatternTypeVariant pType = cmp.method_57446(PRIMARY_TYPE_CODEC).result().orElse(null);
        KoiPrimaryPatternColorVariant pColor = cmp.method_57446(PRIMARY_COLOR_CODEC).result().orElse(null);
        KoiSecondaryPatternTypeVariant sType = cmp.method_57446(SECONDARY_TYPE_CODEC).result().orElse(null);
        KoiSecondaryPatternColorVariant sColor = cmp.method_57446(SECONDARY_COLOR_CODEC).result().orElse(null);
        if (pType != null && pColor != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.clutterbestiary.primary_pattern.koi").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.clutterbestiary." + pType.getName() + ".koi")).method_27692(pType.getFormatting()).method_27692(pColor.getFormatting()));
        }
        if (sType != null && sColor != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.clutterbestiary.secondary_pattern.koi").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.clutterbestiary." + sType.getName() + ".koi")).method_27692(sType.getFormatting()).method_27692(sColor.getFormatting()));
        }
        tooltip.add(class_5244.field_39003);
    }

    private void spawnEntity(class_3218 world, class_1799 stack, class_2338 pos) {
        class_1297 entity = this.type.get().method_5894(world, stack, null, pos, class_3730.field_16473, true, false);
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
            bucketable.method_35170(nbtComponent.method_57461());
            bucketable.method_6454(true);
        }
    }
}

