/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.block.custom;

import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.emilsg.clutterbestiary.entity.variants.ButterflyVariant;
import net.emilsg.clutterbestiary.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ButterflyCocoonBlock
extends Block {
    public static final BooleanProperty CAN_HATCH = BooleanProperty.create((String)"can_hatch");
    public static final IntegerProperty HATCH = IntegerProperty.create((String)"hatch", (int)0, (int)3);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0)});

    public ButterflyCocoonBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.above()).getBlock() instanceof LeavesBlock || world.getBlockState(pos.above()).is(BlockTags.LOGS) || world.getBlockState(pos.above()).is(BlockTags.WART_BLOCKS) || world.getBlockState(pos.above()).is(Blocks.BONE_BLOCK);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Deprecated
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (world.getBlockState(pos.above()).isAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionHand hand = player.getUsedItemHand();
        ItemStack heldItem = player.getItemInHand(hand);
        if (world.isClientSide && heldItem.is(Items.SHEARS) && ((Boolean)state.getValue((Property)CAN_HATCH)).booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        if (!world.isClientSide && heldItem.is(Items.SHEARS) && ((Boolean)state.getValue((Property)CAN_HATCH)).booleanValue()) {
            player.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CAN_HATCH, (Comparable)Boolean.valueOf(false))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)), 3);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextInt(200 + random.nextInt(200)) <= 0) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.MOSS_FALL, SoundSource.BLOCKS, 0.25f, 1.25f, false);
        }
        super.animateTick(state, world, pos, random);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.shouldHatchProgress((Level)world, state)) {
            int i = (Integer)state.getValue((Property)HATCH);
            if (i < 2) {
                world.playSound(null, pos, SoundEvents.MOSS_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                world.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                world.playSound(null, pos, SoundEvents.MOSS_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                world.removeBlock(pos, false);
                if (random.nextInt(2) == 0) {
                    ButterflyCocoonBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.BUTTERFLY_ELYTRA_SMITHING_TEMPLATE_SHARDS.get()));
                }
                for (int j = 0; j < 1; ++j) {
                    world.levelEvent(2001, pos, Block.getId((BlockState)state));
                    ButterflyEntity butterflyEntity = (ButterflyEntity)((EntityType)ModEntityTypes.BUTTERFLY.get()).create((Level)world);
                    if (butterflyEntity == null) continue;
                    Holder registryEntry = world.getBiome(pos);
                    ButterflyVariant variant = ButterflyVariant.getRandom(false);
                    if (registryEntry.is(BiomeTags.IS_OVERWORLD)) {
                        variant = ButterflyVariant.getRandom(true);
                    } else if (registryEntry.is(BiomeTags.IS_NETHER)) {
                        variant = registryEntry.is(Biomes.WARPED_FOREST) ? ButterflyVariant.WARPED : (registryEntry.is(Biomes.CRIMSON_FOREST) ? ButterflyVariant.CRIMSON : (registryEntry.is(Biomes.SOUL_SAND_VALLEY) ? ButterflyVariant.SOUL : (random.nextBoolean() ? ButterflyVariant.CRIMSON : (random.nextBoolean() ? ButterflyVariant.WARPED : ButterflyVariant.SOUL))));
                    }
                    butterflyEntity.setAge(6000);
                    butterflyEntity.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                    butterflyEntity.setVariant(variant);
                    world.addFreshEntity((Entity)butterflyEntity);
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HATCH, CAN_HATCH});
        super.createBlockStateDefinition(builder);
    }

    private boolean shouldHatchProgress(Level world, BlockState state) {
        boolean isDay = world.isDay();
        boolean isNether = world.dimensionTypeRegistration().is(BuiltinDimensionTypes.NETHER);
        if (isDay && ((Boolean)state.getValue((Property)CAN_HATCH)).booleanValue() || isNether) {
            return true;
        }
        if (((Boolean)state.getValue((Property)CAN_HATCH)).booleanValue()) {
            return world.random.nextInt(500) == 0;
        }
        return false;
    }
}

