/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.ChameleonEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.ParentTameableModel;
import net.emilsg.clutterbestiary.entity.custom.ChameleonEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ChameleonModel<T extends ChameleonEntity>
extends ParentTameableModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart head;

    public ChameleonModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.head = this.body.getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.5f, (float)2.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, -5.0f, -4.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.5f, (float)-2.0f));
        PartDefinition backCrest = body.addOrReplaceChild("backCrest", CubeListBuilder.create().texOffs(20, 16).mirror().addBox(0.0f, -2.0f, -3.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 6).addBox(-1.025f, -1.5f, -4.0f, 2.05f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(22, 9).addBox(-1.025f, 0.5f, -1.0f, 2.05f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 17).mirror().addBox(-0.5f, -2.5f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(19, 2).addBox(-1.5f, -1.51f, -3.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.5f, (float)-4.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(16, 13).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)-1.0f));
        PartDefinition tounge = head.addOrReplaceChild("tounge", CubeListBuilder.create().texOffs(8, 2).addBox(-0.5f, 0.75f, -3.0f, 1.0f, 0.5f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.25f, (float)0.0f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(14, 9).addBox(0.0f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.75f, (float)-0.5f, (float)-2.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(14, 9).addBox(-1.0f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.75f, (float)-0.5f, (float)-2.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 24).addBox(-1.0f, -2.5f, 1.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(12, 23).addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.5f, (float)2.0f));
        PartDefinition frontRightLeg = body.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(17, 28).addBox(-0.25f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)-2.5f, (float)-2.5f));
        PartDefinition backRightLeg = body.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(25, 28).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.25f, (float)-2.5f, (float)0.5f));
        PartDefinition frontLeftLeg = body.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(13, 28).addBox(-0.75f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)-2.5f, (float)-2.5f));
        PartDefinition backLeftLeg = body.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(21, 28).addBox(-0.75f, -0.5f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)-2.5f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.5f;
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 1.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.head.offsetScale(this.createVec3f(0.9f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(ChameleonEntity chameleon, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles(chameleon, headYaw, headPitch, headPitch);
        if (!chameleon.isOrderedToSit()) {
            this.animateWalk(ChameleonEntityAnimations.CHAMELEON_WALK, limbAngle, limbDistance, 1.5f, 2.0f);
        } else {
            this.animate(chameleon.sittingAnimationState, ChameleonEntityAnimations.CHAMELEON_LAY_DOWN, animationProgress, 1.0f);
        }
        this.animate(chameleon.toungeIdleAnimationState, ChameleonEntityAnimations.CHAMELEON_LICK_IDLE, animationProgress, 1.0f);
        this.animate(chameleon.tailIdleAnimationState, ChameleonEntityAnimations.CHAMELEON_TAIL_IDLE, animationProgress, 1.0f);
    }

    protected void setHeadAngles(ChameleonEntity entity, float headYaw, float headPitch, float animationProgress) {
        if (this.getHeadPart() == null) {
            return;
        }
        boolean isAttacking = entity.isAggressive();
        float maxYaw = isAttacking ? 60.0f : 30.0f;
        float minYaw = -maxYaw;
        float maxPitch = isAttacking ? 60.0f : 45.0f;
        float minPitch = isAttacking ? -45.0f : -25.0f;
        headYaw = Mth.clamp((float)headYaw, (float)minYaw, (float)maxYaw);
        headPitch = Mth.clamp((float)headPitch, (float)minPitch, (float)maxPitch);
        this.getHeadPart().yRot = headYaw * ((float)Math.PI / 180);
        this.getHeadPart().xRot = headPitch * ((float)Math.PI / 180);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

