/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.DragonflyEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.DragonflyEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class DragonflyModel<T extends DragonflyEntity>
extends BestiaryModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart head;

    public DragonflyModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.head = this.all.getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)22.0f, (float)-4.1f));
        PartDefinition head = all.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 25).addBox(0.5f, -0.5f, -1.475f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(0, 25).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.125f)).texOffs(12, 25).addBox(-1.5f, -0.5f, -1.475f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-0.9f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -2.0f, -0.9f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(18, 16).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(18, 22).addBox(-1.5f, 0.0f, 4.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)6.1f));
        PartDefinition rightFrontWing = body.addOrReplaceChild("rightFrontWing", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, 0.0f, -1.0f, 10.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.75f, (float)-1.75f, (float)1.1f));
        PartDefinition leftFrontWing = body.addOrReplaceChild("leftFrontWing", CubeListBuilder.create().texOffs(0, 12).addBox(0.0f, 0.0f, -1.0f, 10.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.75f, (float)-1.75f, (float)1.1f));
        PartDefinition rightBackWing = body.addOrReplaceChild("rightBackWing", CubeListBuilder.create().texOffs(0, 4).addBox(-10.0f, 0.0f, -2.0f, 10.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.75f, (float)-1.75f, (float)4.1f));
        PartDefinition leftBackWing = body.addOrReplaceChild("leftBackWing", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, 0.0f, -2.0f, 10.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.75f, (float)-1.75f, (float)4.1f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        float scale = this.young ? 0.5f : 1.0f;
        matrices.pushPose();
        matrices.scale(scale, scale, scale);
        matrices.translate(0.0f, this.young ? 1.5f : 0.0f, 0.0f);
        this.root().render(matrices, vertices, light, overlay, color);
        matrices.popPose();
    }

    @Override
    public void setAngles(DragonflyEntity dragonfly, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)dragonfly, netHeadYaw, headPitch, ageInTicks);
        this.animate(dragonfly.flyingAnimState, DragonflyEntityAnimations.DRAGONFLY_FLY, ageInTicks, 2.5f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

