/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.MantaRayEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryAquaticModel;
import net.emilsg.clutterbestiary.entity.custom.MantaRayEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class MantaRayModel<T extends MantaRayEntity>
extends BestiaryAquaticModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private float oldPitch = 0.0f;
    private float oldYaw = 0.0f;

    public MantaRayModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)1.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition leftMandible_r1 = body.addOrReplaceChild("leftMandible_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-5.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)-1.5f, (float)-7.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition rightMandible_r1 = body.addOrReplaceChild("rightMandible_r1", CubeListBuilder.create().texOffs(0, 0).addBox(4.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-1.5f, (float)-7.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.0f, -9.0f, 8.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition leftFin = body.addOrReplaceChild("leftFin", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-1.5f, (float)2.5f));
        PartDefinition leftFin_r1 = leftFin.addOrReplaceChild("leftFin_r1", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-3.0f, -1.0f, -5.5f, 6.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition outerLeftFin = leftFin.addOrReplaceChild("outerLeftFin", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)0.0f, (float)-0.5f));
        PartDefinition outerLeftFin_r1 = outerLeftFin.addOrReplaceChild("outerLeftFin_r1", CubeListBuilder.create().texOffs(31, 0).mirror().addBox(-3.5f, -0.5f, -5.0f, 7.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition rightFin = body.addOrReplaceChild("rightFin", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-1.5f, (float)2.5f));
        PartDefinition rightFin_r1 = rightFin.addOrReplaceChild("rightFin_r1", CubeListBuilder.create().texOffs(23, 20).mirror().addBox(-3.0f, -1.0f, -5.5f, 6.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition outerRightFin = rightFin.addOrReplaceChild("outerRightFin", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)0.0f, (float)-0.5f));
        PartDefinition outerRightFin_r1 = outerRightFin.addOrReplaceChild("outerRightFin_r1", CubeListBuilder.create().texOffs(0, 33).mirror().addBox(-3.5f, -0.5f, -5.0f, 7.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(35, 35).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)9.0f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(0, 6).addBox(0.0f, -1.0f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition outerTail = tail.addOrReplaceChild("outerTail", CubeListBuilder.create().texOffs(24, 33).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.all;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root().render(matrices, vertices, light, overlay, color);
    }

    @Override
    public void setAngles(MantaRayEntity ray, float limbAngle, float limbDistance, float ageInTicks, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.oldPitch = this.lerp(this.oldPitch, headPitch * 0.011453292f, 0.05f);
        this.oldYaw = this.lerp(this.oldYaw, headYaw * 0.011453292f, 0.05f);
        this.root().xRot = this.oldPitch;
        this.root().yRot = this.oldYaw;
        if (ray.isInWater() || ray.isUnderWater()) {
            this.animateWalk(MantaRayEntityAnimations.MANTA_RAY_SWIM, limbAngle, limbDistance, 1.5f, 2.0f);
        } else {
            this.animate(ray.flopAnimationState, MantaRayEntityAnimations.MANTA_RAY_FLOP, ageInTicks, 1.0f);
        }
    }

    private float lerp(float a, float b, float alpha) {
        return a + (b - a) * alpha;
    }
}

