/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.SeahorseEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.ParentFishModel;
import net.emilsg.clutterbestiary.entity.custom.SeahorseEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SeahorseModel<T extends SeahorseEntity>
extends ParentFishModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart stomach;
    private final ModelPart head;

    public SeahorseModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.head = this.body.getChild("head");
        this.stomach = this.body.getChild("stomach");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 2).addBox(0.0f, -2.0f, 1.0f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(4, 2).addBox(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)).texOffs(2, 6).addBox(-0.5f, 1.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition stomach = body.addOrReplaceChild("stomach", CubeListBuilder.create().texOffs(6, 7).addBox(0.0f, -1.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-0.5f, (float)1.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -2.0f, -1.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.2f)).texOffs(8, 0).addBox(-0.5f, -1.0f, -3.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)).texOffs(0, 7).addBox(0.0f, -3.0f, -0.5f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-0.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)2.0f));
        PartDefinition tailOne = tail.addOrReplaceChild("tailOne", CubeListBuilder.create().texOffs(10, 3).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 5).addBox(0.0f, 0.0f, 0.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-1.5f));
        PartDefinition tailTwo = tailOne.addOrReplaceChild("tailTwo", CubeListBuilder.create().texOffs(3, 10).addBox(-0.5f, -0.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.25f)).texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)16, (int)16);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.5f;
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 1.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.getHeadPart().offsetScale(this.createVec3f(0.9f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(SeahorseEntity seahorse, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateParts(seahorse);
        if (seahorse.isInWater() && !seahorse.isDeadOrDying()) {
            this.animate(seahorse.swimmingAnimationState, SeahorseEntityAnimations.SEAHORSE_SWIM, ageInTicks, 1.0f);
        } else if (!seahorse.isDeadOrDying()) {
            this.animate(seahorse.flopAnimationState, SeahorseEntityAnimations.SEAHORSE_FLOP, ageInTicks, 1.0f);
        }
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }

    private void updateParts(SeahorseEntity seahorse) {
        boolean hasChildren = seahorse.hasChildren();
        if (hasChildren) {
            this.stomach.offsetScale(this.createVec3f(seahorse.getHasChildrenTimer()));
        }
    }
}

