/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.emilsg.clutterbestiary.entity.client.layer.ModModelLayers;
import net.emilsg.clutterbestiary.entity.client.model.KoiModel;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class KoiBaseColorFeatureRenderer
extends RenderLayer<KoiEntity, KoiModel<KoiEntity>> {
    private final KoiModel<KoiEntity> layerModel;

    public KoiBaseColorFeatureRenderer(RenderLayerParent<KoiEntity, KoiModel<KoiEntity>> context, EntityModelSet loader) {
        super(context);
        this.layerModel = new KoiModel(loader.bakeLayer(ModModelLayers.KOI_BASE));
    }

    private static int getColor(KoiEntity koiEntity, float tickDelta) {
        int color;
        if (koiEntity.getBaseColorVariant().equals(KoiBaseColorVariant.IRIDESCENT_RAINBOW)) {
            float speed = 4.5f;
            float hue = ((float)koiEntity.tickCount + tickDelta) * speed % 360.0f / 360.0f;
            float saturation = 0.4f;
            float brightness = 1.0f;
            color = Color.HSBtoRGB(hue, saturation, brightness);
        } else {
            if (koiEntity.getBaseColorVariant().hasSeparateTexture()) {
                return 0;
            }
            color = koiEntity.getBaseColorVariant().getColorHex()[0];
        }
        return color;
    }

    public void render(PoseStack matrices, MultiBufferSource providers, int light, KoiEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        int rgb = KoiBaseColorFeatureRenderer.getColor(entity, tickDelta);
        if (rgb == 0) {
            return;
        }
        int argb = 0xFF000000 | rgb & 0xFFFFFF;
        ResourceLocation texture = this.getTextureLocation((Entity)entity);
        if (entity.isInvisible()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.shouldEntityAppearGlowing((Entity)entity)) {
                ((KoiModel)this.getParentModel()).copyPropertiesTo((EntityModel)this.layerModel);
                this.layerModel.prepareMobModel((Entity)entity, limbAngle, limbDistance, tickDelta);
                this.layerModel.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                VertexConsumer vc = providers.getBuffer(RenderType.outline((ResourceLocation)texture));
                this.layerModel.renderToBuffer(matrices, vc, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), -16777216);
            }
            return;
        }
        KoiBaseColorFeatureRenderer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.layerModel, (ResourceLocation)texture, (PoseStack)matrices, (MultiBufferSource)providers, (int)light, (LivingEntity)entity, (float)limbAngle, (float)limbDistance, (float)animationProgress, (float)headYaw, (float)headPitch, (float)tickDelta, (int)argb);
    }
}

