/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.layer.ModModelLayers;
import net.emilsg.clutterbestiary.entity.client.model.KoiModel;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class KoiPrimaryPatternColorFeatureRenderer
extends RenderLayer<KoiEntity, KoiModel<KoiEntity>> {
    private final KoiModel<KoiEntity> layerModel;

    public KoiPrimaryPatternColorFeatureRenderer(RenderLayerParent<KoiEntity, KoiModel<KoiEntity>> context, EntityModelSet loader) {
        super(context);
        this.layerModel = new KoiModel(loader.bakeLayer(ModModelLayers.KOI_PRIMARY_COLOR));
    }

    public void render(PoseStack matrices, MultiBufferSource providers, int light, KoiEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (entity.getBaseColorVariant().hasSeparateTexture()) {
            return;
        }
        if (entity.getPrimaryPatternTypeVariant() == KoiPrimaryPatternTypeVariant.NONE) {
            return;
        }
        int rgb = entity.getPrimaryPatternColorVariant().getColorHex();
        if (rgb == 0) {
            return;
        }
        int argb = 0xFF000000 | rgb & 0xFFFFFF;
        ResourceLocation texture = entity.getPrimaryPatternTypeVariant().getTextureLocation();
        if (entity.isInvisible()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.shouldEntityAppearGlowing((Entity)entity)) {
                ((KoiModel)this.getParentModel()).copyPropertiesTo((EntityModel)this.layerModel);
                this.layerModel.prepareMobModel((Entity)entity, limbAngle, limbDistance, tickDelta);
                this.layerModel.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                VertexConsumer vc = providers.getBuffer(RenderType.outline((ResourceLocation)texture));
                this.layerModel.renderToBuffer(matrices, vc, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), -16777216);
            }
            return;
        }
        KoiPrimaryPatternColorFeatureRenderer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.layerModel, (ResourceLocation)texture, (PoseStack)matrices, (MultiBufferSource)providers, (int)light, (LivingEntity)entity, (float)limbAngle, (float)limbDistance, (float)animationProgress, (float)headYaw, (float)headPitch, (float)tickDelta, (int)argb);
    }
}

