/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.time.LocalDate;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyDupeSporeBlossomGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyPlaceCocoonGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyWanderNetherGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.ButterflyWanderOverworldGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.variants.ButterflyVariant;
import net.emilsg.clutterbestiary.item.ModItems;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class ButterflyEntity
extends ParentAnimalEntity {
    private static final EntityDataAccessor<Boolean> HAS_COCOON = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DUPE_TIMER = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> FLYING_TYPE_VARIANT = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState flyingAnimState = new AnimationState();
    private int animationTimeout = 0;

    public ButterflyEntity(EntityType<? extends ParentAnimalEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new ButterflyLookControl((Mob)this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    private static boolean isTodayAroundHalloween() {
        LocalDate localDate = LocalDate.now();
        int i = localDate.getDayOfMonth();
        int j = localDate.getMonth().getValue();
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.BUTTERFLIES_SPAWN_ON);
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal other) {
        super.spawnChildFromBreeding(world, other);
        ServerPlayer serverPlayerEntity = this.getLoveCause();
        if (serverPlayerEntity == null && other.getLoveCause() != null) {
            serverPlayerEntity = other.getLoveCause();
        }
        if (serverPlayerEntity != null) {
            serverPlayerEntity.awardStat(Stats.ANIMALS_BRED);
            CriteriaTriggers.BRED_ANIMALS.trigger(serverPlayerEntity, (Animal)this, other, null);
        }
        this.setHasCocoon(true);
        this.setAge(6000);
        other.setAge(6000);
        this.resetLove();
        other.resetLove();
        world.broadcastEntityEvent((Entity)this, (byte)18);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public void copyDataFromNbt(ButterflyEntity entity, CompoundTag nbt) {
        if (nbt.contains("NoAI")) {
            entity.setNoAi(nbt.getBoolean("NoAI"));
        }
        if (nbt.contains("Silent")) {
            entity.setSilent(nbt.getBoolean("Silent"));
        }
        if (nbt.contains("NoGravity")) {
            entity.setNoGravity(nbt.getBoolean("NoGravity"));
        }
        if (nbt.contains("Glowing")) {
            entity.setGlowingTag(nbt.getBoolean("Glowing"));
        }
        if (nbt.contains("Invulnerable")) {
            entity.setInvulnerable(nbt.getBoolean("Invulnerable"));
        }
        if (nbt.contains("FlyingVariant")) {
            entity.setFlyingVariant(nbt.getInt("FlyingVariant"));
        }
        if (nbt.contains("Variant")) {
            entity.setVariant(ButterflyVariant.fromId(nbt.getString("Variant")));
        }
        if (nbt.contains("Health", 99)) {
            entity.setHealth(nbt.getFloat("Health"));
        }
    }

    public void copyDataToStack(ButterflyEntity entity, ItemStack stack) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)entity.getCustomName());
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, nbtCompound -> {
            if (entity.isNoAi()) {
                nbtCompound.putBoolean("NoAI", entity.isNoAi());
            }
            if (entity.isSilent()) {
                nbtCompound.putBoolean("Silent", entity.isSilent());
            }
            if (entity.isNoGravity()) {
                nbtCompound.putBoolean("NoGravity", entity.isNoGravity());
            }
            if (entity.isCurrentlyGlowing()) {
                nbtCompound.putBoolean("Glowing", entity.isCurrentlyGlowing());
            }
            if (entity.isInvulnerable()) {
                nbtCompound.putBoolean("Invulnerable", entity.isInvulnerable());
            }
            nbtCompound.putFloat("Health", entity.getHealth());
            nbtCompound.putString("Variant", entity.getTypeVariant());
        });
    }

    public int getDupeTimer() {
        return (Integer)this.entityData.get(DUPE_TIMER);
    }

    public void setDupeTimer(int time) {
        this.entityData.set(DUPE_TIMER, (Object)time);
    }

    public int getFlyingTypeVariant() {
        return (Integer)this.entityData.get(FLYING_TYPE_VARIANT);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public ButterflyVariant getVariant() {
        return ButterflyVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(ButterflyVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean hasCocoon() {
        return (Boolean)this.entityData.get(HAS_COCOON);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Holder registryEntry = world.getBiome(this.blockPosition());
        ButterflyVariant variant = ButterflyVariant.getRandom(false);
        if (spawnReason.equals((Object)MobSpawnType.SPAWN_EGG)) {
            variant = (ButterflyVariant)((Object)Util.getRandom((Object[])ButterflyVariant.values(), (RandomSource)this.random));
        }
        if (registryEntry.is(BiomeTags.IS_OVERWORLD)) {
            variant = ButterflyVariant.getRandom(true);
        } else if (registryEntry.is(BiomeTags.IS_NETHER)) {
            variant = registryEntry.is(Biomes.WARPED_FOREST) ? ButterflyVariant.WARPED : (registryEntry.is(Biomes.CRIMSON_FOREST) ? ButterflyVariant.CRIMSON : (registryEntry.is(Biomes.SOUL_SAND_VALLEY) ? ButterflyVariant.SOUL : (this.random.nextBoolean() ? ButterflyVariant.CRIMSON : (this.random.nextBoolean() ? ButterflyVariant.WARPED : ButterflyVariant.SOUL))));
        }
        this.setVariant(variant);
        this.setFlyingVariant(this.random.nextInt(3));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        this.tryBottle(player, hand, this);
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(Items.SUGAR);
    }

    public boolean wasExperienceConsumed() {
        return true;
    }

    public boolean fireImmune() {
        return this.getVariant().isFireImmune();
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setHasCocoon(nbt.getBoolean("HasCocoon"));
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
        this.setDupeTimer(nbt.getInt("DupeTimer"));
        this.entityData.set(FLYING_TYPE_VARIANT, (Object)nbt.getInt("FlyingVariant"));
    }

    public void setFlyingVariant(int flyingVariant) {
        this.entityData.set(FLYING_TYPE_VARIANT, (Object)flyingVariant);
    }

    public void setHasCocoon(boolean hasCocoon) {
        this.entityData.set(HAS_COCOON, (Object)hasCocoon);
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getDupeTimer() < 8000) {
            this.setDupeTimer(this.getDupeTimer() + 1);
        }
        if (this.isAlive() && (this.isEyeInFluid(FluidTags.LAVA) || this.isEyeInFluid(FluidTags.WATER))) {
            this.kill();
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("HasCocoon", this.hasCocoon());
        nbt.putString("Variant", this.getTypeVariant());
        nbt.putInt("DupeTimer", this.getDupeTimer());
        nbt.putInt("FlyingVariant", this.getFlyingTypeVariant());
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.getBlockState(pos.below()).isAir();
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.WOOL_BREAK;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WOOL_HIT;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_COCOON, (Object)false);
        builder.define(DUPE_TIMER, (Object)0);
        builder.define(VARIANT, (Object)ButterflyVariant.WHITE.getId());
        builder.define(FLYING_TYPE_VARIANT, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new ButterflyPlaceCocoonGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), false));
        this.goalSelector.addGoal(3, (Goal)new ButterflyDupeSporeBlossomGoal(this, 1.0, 1200));
        this.goalSelector.addGoal(4, (Goal)new ButterflyWanderNetherGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ButterflyWanderOverworldGoal(this));
    }

    protected void createWitherRose(@Nullable LivingEntity adversary) {
        if (ButterflyEntity.isTodayAroundHalloween() && adversary instanceof Player && this.random.nextInt(10) == 0) {
            adversary.hurt(this.level().damageSources().magic(), 6.0f);
        }
        super.createWitherRose(adversary);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 10;
            this.flyingAnimState.start(this.tickCount);
        } else {
            --this.animationTimeout;
        }
    }

    private void tryBottle(Player player, InteractionHand hand, ButterflyEntity entity) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() == Items.GLASS_BOTTLE && entity.isAlive()) {
            entity.playSound(SoundEvents.BOTTLE_FILL_DRAGONBREATH, 1.0f, 0.75f);
            ItemStack bottleStack = new ItemStack((ItemLike)ModItems.BUTTERFLY_IN_A_BOTTLE.get());
            this.copyDataToStack(entity, bottleStack);
            ItemStack butterflyBottleStack = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)bottleStack, (boolean)false);
            player.swing(hand);
            player.setItemInHand(hand, butterflyBottleStack);
            entity.discard();
        }
    }

    static class ButterflyLookControl
    extends LookControl {
        ButterflyLookControl(Mob entity) {
            super(entity);
        }

        public void tick() {
            super.tick();
        }

        protected boolean resetXRotOnTick() {
            return true;
        }
    }
}

