/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.Objects;
import net.emilsg.clutterbestiary.entity.custom.goal.EchofinConditionalActiveTargetGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EchofinWanderAroundGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.variants.EchofinVariant;
import net.emilsg.clutterbestiary.item.ModItems;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EchofinEntity
extends ParentAnimalEntity {
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.defineId(EchofinEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(EchofinEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> ABILITY_TIMER = SynchedEntityData.defineId(EchofinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState movingAnimState = new AnimationState();
    final int maxAbilityTimer = 2400;
    private int animationTimeout = 0;

    public EchofinEntity(EntityType<? extends ParentAnimalEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new EchofinLookControl((Mob)this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FLYING_SPEED, 0.75).add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.ECHOFINS_SPAWN_ON);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setVariant(EchofinVariant.getRandom());
        this.setHomePos(this.blockPosition());
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return true;
    }

    public int getAbilityTimerEntitiesTimer() {
        return (Integer)this.entityData.get(ABILITY_TIMER);
    }

    public BlockPos getHomePos() {
        return (BlockPos)this.entityData.get(HOME_POS);
    }

    public void setHomePos(BlockPos pos) {
        this.entityData.set(HOME_POS, (Object)pos);
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public EchofinVariant getVariant() {
        return EchofinVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(EchofinVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean hasAbility() {
        return this.getAbilityTimerEntitiesTimer() >= 2400;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!this.level().isClientSide && heldItem.is(Items.BUCKET)) {
            EchofinVariant variant = this.getVariant();
            Item returnItem = Objects.requireNonNull(variant) == EchofinVariant.CHORUS ? (Item)ModItems.CHORUS_ECHOFIN_BUCKET.get() : (Item)ModItems.LEVITATING_ECHOFIN_BUCKET.get();
            if (player.getItemInHand(hand).getCount() == 1) {
                player.setItemInHand(hand, new ItemStack((ItemLike)returnItem));
            } else {
                heldItem.shrink(1);
                if (player.getInventory().getFreeSlot() > 0) {
                    player.addItem(new ItemStack((ItemLike)returnItem));
                } else {
                    this.spawnAtLocation((ItemLike)returnItem);
                }
            }
            player.playSound(SoundEvents.BUCKET_FILL_FISH, 1.0f, 1.5f);
            this.remove(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean wasExperienceConsumed() {
        return true;
    }

    public void handleDamageEvent(DamageSource damageSource) {
        super.handleDamageEvent(damageSource);
        this.setEntityAbilityTimer(0);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        int i = nbt.getInt("HomePosX");
        int j = nbt.getInt("HomePosY");
        int k = nbt.getInt("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
        this.setEntityAbilityTimer(nbt.getInt("AbilityTimer"));
    }

    public void moveTo(BlockPos pos, float yaw, float pitch) {
        this.setHomePos(pos);
        super.moveTo(pos, yaw, pitch);
    }

    public void setEntityAbilityTimer(int timer) {
        this.entityData.set(ABILITY_TIMER, (Object)timer);
    }

    public boolean shouldLevitatePlayers() {
        return this.hasAbility() && this.getVariant() == EchofinVariant.LEVITATING;
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public boolean shouldTeleportPlayers() {
        return this.hasAbility() && this.getVariant() == EchofinVariant.CHORUS;
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world instanceof ServerLevel) {
            this.setEntityAbilityTimer(this.getAbilityTimerEntitiesTimer() + this.random.nextInt(3));
            if (this.hasAbility() && this.random.nextInt(1000) == 0) {
                this.setEntityAbilityTimer(0);
            }
        }
        if (world.isClientSide) {
            this.setupAnimationStates();
            if (this.getVariant() == EchofinVariant.CHORUS && this.random.nextBoolean()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, true, this.getX() + this.random.nextDouble() / 4.0 * (double)(this.random.nextBoolean() ? 1 : -1), this.getY() + this.random.nextDouble() / 16.0 * (double)(this.random.nextBoolean() ? 1 : -1), this.getZ() + this.random.nextDouble() / 4.0 * (double)(this.random.nextBoolean() ? 1 : -1), this.random.nextBoolean() ? 0.1 : -0.1, this.random.nextBoolean() ? 0.1 : -0.1, this.random.nextBoolean() ? 0.1 : -0.1);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("HomePosX", this.getHomePos().getX());
        nbt.putInt("HomePosY", this.getHomePos().getY());
        nbt.putInt("HomePosZ", this.getHomePos().getZ());
        nbt.putString("Variant", this.getTypeVariant());
        nbt.putInt("AbilityTimer", this.getAbilityTimerEntitiesTimer());
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.getBlockState(pos.below()).isAir();
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.SALMON_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SALMON_HURT;
    }

    public void playerTouch(Player player) {
        super.playerTouch(player);
        Level world = player.level();
        if (world.isClientSide) {
            return;
        }
        if (this.shouldTeleportPlayers()) {
            this.teleportPlayer(player, world);
        } else if (this.shouldLevitatePlayers()) {
            this.levitatePlayer(player);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOME_POS, (Object)BlockPos.ZERO);
        builder.define(VARIANT, (Object)EchofinVariant.CHORUS.getId());
        builder.define(ABILITY_TIMER, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 3.0, true));
        this.goalSelector.addGoal(2, (Goal)new EchofinWanderAroundGoal(this));
        this.targetSelector.addGoal(1, (Goal)new EchofinConditionalActiveTargetGoal(this, Player.class, false));
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    private void levitatePlayer(Player player) {
        player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 100, 2), (Entity)this);
        if (this.random.nextBoolean()) {
            this.setEntityAbilityTimer(0);
        }
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 20;
            this.movingAnimState.start(this.tickCount);
        } else {
            --this.animationTimeout;
        }
    }

    private void teleportPlayer(Player player, Level world) {
        for (int i = 0; i < 16; ++i) {
            double x = player.getX() + (player.level().getRandom().nextDouble() - 0.5) * 512.0;
            double y = Mth.clamp((double)(player.getY() + (double)(player.level().getRandom().nextInt(16) - 8)), (double)world.getMinBuildHeight(), (double)(world.getMinBuildHeight() + ((ServerLevel)world).getLogicalHeight() - 1));
            double z = player.getZ() + (player.level().getRandom().nextDouble() - 0.5) * 512.0;
            if (player.isPassenger()) {
                player.stopRiding();
            }
            Vec3 vec3d = player.position();
            if (!player.randomTeleport(x, y, z, true)) continue;
            world.gameEvent((Holder)GameEvent.TELEPORT, vec3d, GameEvent.Context.of((Entity)player));
            this.setEntityAbilityTimer(0);
            break;
        }
    }

    private static class EchofinLookControl
    extends LookControl {
        EchofinLookControl(Mob entity) {
            super(entity);
        }

        public void tick() {
            super.tick();
        }

        protected boolean resetXRotOnTick() {
            return true;
        }
    }
}

