/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.function.Predicate;
import net.emilsg.clutterbestiary.block.ModBlocks;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.KiwiBirdLayEggGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.KiwiBirdMateGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.KiwiBirdWanderAroundFarGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.emilsg.clutterbestiary.util.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class KiwiBirdEntity
extends ParentAnimalEntity {
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.of(ModItemTags.C_SEEDS);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(KiwiBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> EGG_TIMER = SynchedEntityData.defineId(KiwiBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_DANCING = SynchedEntityData.defineId(KiwiBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState dancingAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public int dancingAnimationTimeout = 0;
    private boolean songPlaying;
    @Nullable
    private BlockPos songSource;

    public KiwiBirdEntity(EntityType<? extends ParentAnimalEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.225f).add(Attributes.ATTACK_SPEED, 0.5).add(Attributes.ATTACK_KNOCKBACK, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public boolean canFallInLove() {
        return super.canFallInLove() && !this.hasEgg() && !this.isDancing();
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.KIWIS_SPAWN_ON);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)ModEntityTypes.KIWI_BIRD.get()).create((Level)world);
    }

    public int getEggTimer() {
        return (Integer)this.entityData.get(EGG_TIMER);
    }

    public void setEggTimer(int time) {
        this.entityData.set(EGG_TIMER, (Object)time);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(ModItemTags.C_SEEDS);
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(IS_DANCING);
    }

    public void setDancing(boolean dancing) {
        this.entityData.set(IS_DANCING, (Object)dancing);
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setHasEgg(nbt.getBoolean("HasEgg"));
        this.setEggTimer(nbt.getInt("EggTimer"));
        this.setDancing(nbt.getBoolean("IsDancing"));
    }

    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public void setRecordPlayingNearby(BlockPos songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
        if (this.songSource == null || !this.songSource.closerToCenterThan((Position)this.position(), 3.46) || !this.level().getBlockState(this.songSource).is(Blocks.JUKEBOX)) {
            this.songPlaying = false;
            this.songSource = null;
        }
        this.setDancing(this.isSongPlaying());
    }

    @Override
    public void aiStep() {
        if (this.hasEgg()) {
            this.setEggTimer(this.getEggTimer() + 1);
        }
        super.aiStep();
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("HasEgg", this.hasEgg());
        nbt.putInt("EggTimer", this.getEggTimer());
        nbt.putBoolean("IsDancing", this.isDancing());
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ModSoundEvents.ENTITY_KIWI_CALL.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.PARROT_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PARROT_HURT;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_EGG, (Object)false);
        builder.define(EGG_TIMER, (Object)0);
        builder.define(IS_DANCING, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new KiwiBirdMateGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new KiwiBirdLayEggGoal(this, 1.0, ((Block)ModBlocks.KIWI_BIRD_EGG.get()).defaultBlockState()));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new KiwiBirdWanderAroundFarGoal(this, (PathfinderMob)this, 1.0, 1.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.PARROT_STEP, 0.15f, 0.75f);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.isMoving() && !this.isSongPlaying()) {
            this.idleAnimationTimeout = 30;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.dancingAnimationTimeout <= 0 && this.isSongPlaying()) {
            this.dancingAnimationTimeout = 20;
            this.dancingAnimationState.start(this.tickCount);
        } else {
            --this.dancingAnimationTimeout;
        }
    }
}

