/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.MossbloomDropHornsGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.TrackedFleeGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.WanderAroundFarOftenGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.entity.variants.MossbloomVariant;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MossbloomEntity
extends ParentTameableEntity
implements PlayerRideable,
PlayerRideableJumping {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(MossbloomEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> HAS_HORNS = SynchedEntityData.defineId(MossbloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> HORN_DROP_TIMER = SynchedEntityData.defineId(MossbloomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TIME_TILL_DROP = SynchedEntityData.defineId(MossbloomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_SHAKING = SynchedEntityData.defineId(MossbloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SPRINTING = SynchedEntityData.defineId(MossbloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.defineId(MossbloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static int SHOULD_DROP_HORNS_VALUE = 12000;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState shakingAnimationState = new AnimationState();
    public final AnimationState earTwitchAnimationStateLE = new AnimationState();
    public final AnimationState earTwitchAnimationStateRE = new AnimationState();
    public final AnimationState earTwitchAnimationStateBE = new AnimationState();
    public final AnimationState wagTailAnimationStateBE = new AnimationState();
    public int idleAnimationTimeout = 0;
    public int shakingAnimationTimeout = 0;
    public int earTwitchAnimationTimeout = 0;
    protected int soundTicks;
    protected boolean inAir;
    protected float jumpStrength;
    private final Item tamingItem = Items.SPORE_BLOSSOM;

    public MossbloomEntity(EntityType<? extends ParentTameableEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.JUMP_STRENGTH, 0.75).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.MOSSBLOOMS_SPAWN_ON);
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal other) {
        MossbloomEntity child = (MossbloomEntity)this.getBreedOffspring(world, (AgeableMob)other);
        if (child != null) {
            ServerPlayer serverPlayerEntity = this.getLoveCause();
            if (serverPlayerEntity == null && other.getLoveCause() != null) {
                serverPlayerEntity = other.getLoveCause();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.awardStat(Stats.ANIMALS_BRED);
                CriteriaTriggers.BRED_ANIMALS.trigger(serverPlayerEntity, (Animal)this, other, (AgeableMob)child);
            }
            this.setAge(6000);
            other.setAge(6000);
            this.resetLove();
            other.resetLove();
            child.setBaby(true);
            boolean isVariantHorned = this.random.nextBoolean();
            child.setVariant(isVariantHorned ? MossbloomVariant.HORNED : MossbloomVariant.FLOWERING);
            child.setHasHorns(isVariantHorned);
            if (isVariantHorned) {
                child.setHornDropTimer(-SHOULD_DROP_HORNS_VALUE);
            }
            child.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
            world.addFreshEntityWithPassengers((Entity)child);
            world.broadcastEntityEvent((Entity)this, (byte)18);
            if (world.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                world.addFreshEntity((Entity)new ExperienceOrb((Level)world, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
            }
        }
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!state.liquid()) {
            BlockState blockState = this.level().getBlockState(pos.above());
            SoundType blockSoundGroup = state.getSoundType();
            if (blockState.is(Blocks.SNOW)) {
                blockSoundGroup = blockState.getSoundType();
            }
            if (this.isVehicle()) {
                ++this.soundTicks;
                if (this.soundTicks > 5 && this.soundTicks % 3 == 0) {
                    this.playWalkSound(blockSoundGroup);
                } else if (this.soundTicks <= 5) {
                    this.playSound(SoundEvents.HORSE_STEP_WOOD, blockSoundGroup.getVolume() * 0.15f, blockSoundGroup.getPitch() + 0.5f);
                }
            } else if (this.isWooden(blockSoundGroup)) {
                this.playSound(SoundEvents.HORSE_STEP_WOOD, blockSoundGroup.getVolume() * 0.15f, blockSoundGroup.getPitch() + 0.5f);
            } else {
                this.playSound(SoundEvents.HORSE_STEP, blockSoundGroup.getVolume() * 0.15f, blockSoundGroup.getPitch() + 0.5f);
            }
        }
    }

    protected void playWalkSound(SoundType group) {
        this.playSound(SoundEvents.HORSE_GALLOP, group.getVolume() * 0.05f, group.getPitch() + 0.25f);
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.HORSE_BREATHE, group.getVolume() * 0.6f, group.getPitch() + 0.5f);
        }
    }

    private boolean isWooden(SoundType soundGroup) {
        return soundGroup == SoundType.WOOD || soundGroup == SoundType.NETHER_WOOD || soundGroup == SoundType.STEM || soundGroup == SoundType.CHERRY_WOOD || soundGroup == SoundType.BAMBOO_WOOD;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i;
        if (fallDistance > 1.0f) {
            this.playSound(SoundEvents.HORSE_LAND, 0.4f, 1.75f);
        }
        if ((i = this.calculateFallDamage(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.hurt(damageSource, i);
        if (this.isVehicle()) {
            for (Entity entity : this.getIndirectPassengers()) {
                entity.hurt(damageSource, (float)i);
            }
        }
        this.playBlockFallSound();
        return true;
    }

    protected int calculateFallDamage(float fallDistance, float damageMultiplier) {
        return Mth.ceil((float)((fallDistance * 0.5f - 3.0f) * damageMultiplier));
    }

    public boolean canMate(Animal other) {
        if (other == this) {
            return false;
        }
        if (other.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (((MossbloomEntity)other).getVariant().getId().equals(this.getVariant().getId())) {
            return false;
        }
        return this.isInLove() && other.isInLove();
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        BlockPos pos = this.blockPosition();
        BlockState blockState = world.getBlockState(pos.below());
        return blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.STONE) || blockState.is(Blocks.MOSS_BLOCK) || blockState.is(Blocks.CLAY);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        MossbloomEntity child = (MossbloomEntity)((EntityType)ModEntityTypes.MOSSBLOOM.get()).create((Level)world);
        if (child != null) {
            child.setVariant(MossbloomVariant.getRandom());
        }
        return child;
    }

    public boolean getHasHorns() {
        return (Boolean)this.entityData.get(HAS_HORNS);
    }

    public void setHasHorns(boolean hasHorns) {
        this.entityData.set(HAS_HORNS, (Object)hasHorns);
    }

    public int getHornDropTimer() {
        return (Integer)this.entityData.get(HORN_DROP_TIMER);
    }

    public void setHornDropTimer(int hornDropTimer) {
        this.entityData.set(HORN_DROP_TIMER, (Object)hornDropTimer);
    }

    public boolean getIsShaking() {
        return (Boolean)this.entityData.get(IS_SHAKING);
    }

    public void setIsShaking(boolean isShaking) {
        this.entityData.set(IS_SHAKING, (Object)isShaking);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSoundEvents.ENTITY_MOSSBLOOM_HURT.get();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public int getTimeTillDrop() {
        return (Integer)this.entityData.get(TIME_TILL_DROP);
    }

    public void onPlayerJump(int strength) {
        if (this.getIsSaddled()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.jumping = true;
            }
            this.jumpStrength = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    protected void tickRidden(Player controllingPlayer, Vec3 movementInput) {
        super.tickRidden(controllingPlayer, movementInput);
        Vec2 vec2f = this.getControlledRotation((LivingEntity)controllingPlayer);
        this.setRot(vec2f.y, vec2f.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isControlledByLocalInstance() && this.onGround()) {
            this.setInAir(false);
            if (this.jumpStrength > 0.0f && !this.isInAir()) {
                this.jump(this.jumpStrength, movementInput);
            }
            this.jumpStrength = 0.0f;
        }
    }

    protected Vec3 getRiddenInput(Player controllingPlayer, Vec3 movementInput) {
        if (this.onGround() && this.jumpStrength == 0.0f && !this.jumping) {
            return Vec3.ZERO;
        }
        float f = controllingPlayer.xxa * 0.5f;
        float g = controllingPlayer.zza;
        if (g <= 0.0f) {
            g *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)g);
    }

    protected void jump(float strength, Vec3 movementInput) {
        double d = this.getJumpStrength() * (double)strength * (double)this.getBlockJumpFactor();
        double e = d + (double)this.getJumpBoostPower();
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x, e, vec3d.z);
        this.setInAir(true);
        this.hasImpulse = true;
        if (movementInput.z > 0.0) {
            float f = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float g = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * f * strength), 0.0, (double)(0.4f * g * strength)));
        }
    }

    public double getJumpStrength() {
        return this.getAttributeValue(Attributes.JUMP_STRENGTH);
    }

    public boolean isInAir() {
        return this.inAir;
    }

    public void setInAir(boolean inAir) {
        this.inAir = inAir;
    }

    protected Vec2 getControlledRotation(LivingEntity controllingPassenger) {
        return new Vec2(controllingPassenger.getXRot() * 0.5f, controllingPassenger.getYRot());
    }

    public boolean canJump() {
        return this.getIsSaddled();
    }

    public void handleStartJump(int height) {
        this.jumping = true;
    }

    public void handleStopJump() {
    }

    public void setTimeTillDrop(int timeTillDrop) {
        this.entityData.set(TIME_TILL_DROP, (Object)timeTillDrop);
    }

    public boolean getSprinting() {
        return (Boolean)this.entityData.get(IS_SPRINTING);
    }

    public void setIsSprinting(boolean sprinting) {
        this.entityData.set(IS_SPRINTING, (Object)sprinting);
    }

    public boolean getIsSaddled() {
        return (Boolean)this.entityData.get(IS_SADDLED);
    }

    public void setIsSaddled(boolean saddled) {
        this.entityData.set(IS_SADDLED, (Object)saddled);
    }

    public String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public MossbloomVariant getVariant() {
        return MossbloomVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(MossbloomVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        MossbloomVariant variant = MossbloomVariant.getRandom();
        this.setVariant(variant);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(Items.BIG_DRIPLEAF);
    }

    public boolean isVariantOf(MossbloomVariant variant) {
        return this.getVariant() == variant;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
        this.entityData.set(HAS_HORNS, (Object)nbt.getBoolean("HasHorns"));
        this.entityData.set(HORN_DROP_TIMER, (Object)nbt.getInt("HornDropTimer"));
        this.entityData.set(IS_SHAKING, (Object)nbt.getBoolean("IsShaking"));
        this.entityData.set(IS_SADDLED, (Object)nbt.getBoolean("IsSaddled"));
    }

    public boolean isImmobile() {
        return super.isImmobile() && this.isVehicle() && this.getIsSaddled();
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (this.getVariant() == MossbloomVariant.FLOWERING && this.getRandom().nextInt(4800) == 0) {
            this.tickFertilize(world);
        }
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
        if (this.getVariant() == MossbloomVariant.HORNED && !this.isBaby()) {
            if (this.getHornDropTimer() >= SHOULD_DROP_HORNS_VALUE / 3) {
                this.setHasHorns(true);
            }
            this.setHornDropTimer(this.getHornDropTimer() + this.random.nextInt(1) + 1);
        }
        if (this.getVariant() == MossbloomVariant.HORNED && this.isBaby()) {
            this.setHasHorns(false);
        }
        this.jumping = false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (this.isTame() && hand == InteractionHand.MAIN_HAND) {
            if (!player.isShiftKeyDown()) {
                if (!this.getIsSaddled() && itemStack.is(Items.SADDLE)) {
                    if (!player.getAbilities().instabuild) {
                        itemStack.shrink(1);
                    }
                    this.setIsSaddled(true);
                    this.level().playSound(null, this.blockPosition(), SoundEvents.PIG_SADDLE, SoundSource.NEUTRAL, 0.5f, 1.25f);
                    return InteractionResult.SUCCESS;
                }
                if (itemStack.isEmpty()) {
                    this.setRiding(player);
                    return InteractionResult.SUCCESS;
                }
            }
            if (item instanceof ShearsItem) {
                this.setIsSaddled(false);
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                this.spawnAtLocation(new ItemStack((ItemLike)Items.SADDLE), 0.5f);
                this.level().playSound(null, this.blockPosition(), SoundEvents.MOOSHROOM_SHEAR, SoundSource.NEUTRAL, 0.5f, 1.25f);
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.isTame() && item == this.tamingItem) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            this.level().playSound(null, this.blockPosition(), SoundEvents.HORSE_EAT, SoundSource.NEUTRAL, 0.5f, 1.75f);
            if (this.random.nextInt(8) == 0) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.isUnderWater() && this.getControllingPassenger() != null) {
            this.getControllingPassenger().removeVehicle();
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Variant", this.getTypeVariant());
        nbt.putBoolean("HasHorns", this.getHasHorns());
        nbt.putInt("HornDropTimer", this.getHornDropTimer());
        nbt.putBoolean("IsShaking", this.getIsShaking());
        nbt.putBoolean("IsSaddled", this.getIsSaddled());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)MossbloomVariant.HORNED.getId());
        builder.define(HAS_HORNS, (Object)true);
        builder.define(HORN_DROP_TIMER, (Object)0);
        builder.define(IS_SHAKING, (Object)false);
        builder.define(TIME_TILL_DROP, (Object)0);
        builder.define(IS_SPRINTING, (Object)false);
        builder.define(IS_SADDLED, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MossbloomDropHornsGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TrackedFleeGoal(this, 2.5));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BIG_DRIPLEAF}), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WanderAroundFarOftenGoal((PathfinderMob)this, 1.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby() && this.getVariant() == MossbloomVariant.HORNED) {
            this.setHasHorns(true);
        }
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f * 1.5f, 0.5f);
    }

    private void pickRandomIdleAnim(int i) {
        switch (i) {
            case 1: {
                this.earTwitchAnimationStateRE.startIfStopped(this.tickCount);
                break;
            }
            case 2: {
                this.earTwitchAnimationStateLE.startIfStopped(this.tickCount);
                break;
            }
            case 3: {
                this.wagTailAnimationStateBE.startIfStopped(this.tickCount);
                break;
            }
            default: {
                this.earTwitchAnimationStateBE.startIfStopped(this.tickCount);
            }
        }
    }

    private void setupAnimationStates() {
        if (this.shakingAnimationTimeout <= 0 && this.getIsShaking()) {
            this.shakingAnimationTimeout = 60;
            this.shakingAnimationState.start(this.tickCount);
        } else {
            --this.shakingAnimationTimeout;
        }
        if (this.idleAnimationTimeout <= 0 && !this.isMoving()) {
            this.idleAnimationTimeout = 10;
            this.idleAnimationState.startIfStopped(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.earTwitchAnimationTimeout <= 0 && this.random.nextInt(50) == 0) {
            this.earTwitchAnimationTimeout = 5;
            this.pickRandomIdleAnim(this.random.nextInt(4));
        } else {
            --this.earTwitchAnimationTimeout;
        }
    }

    private void tickFertilize(Level world) {
        BlockPos origin = this.blockPosition();
        int ox = origin.getX();
        int oy = origin.getY();
        int oz = origin.getZ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        RandomSource rand = this.getRandom();
        int dyStart = rand.nextInt(3);
        int dyStep = rand.nextBoolean() ? 1 : 2;
        int dxStart = rand.nextInt(11);
        int dxStep = rand.nextInt(10) + 1;
        int dzStart = rand.nextInt(11);
        int dzStep = rand.nextInt(10) + 1;
        int maxChecks = 32;
        block0: for (int yi = 0; yi < 3; ++yi) {
            int dy = (dyStart + yi * dyStep) % 3 - 1;
            for (int xi = 0; xi < 11; ++xi) {
                int dx = (dxStart + xi * dxStep) % 11 - 5;
                for (int zi = 0; zi < 11; ++zi) {
                    BonemealableBlock fertilizable;
                    if (--maxChecks < 0) break block0;
                    int dz = (dzStart + zi * dzStep) % 11 - 5;
                    pos.set(ox + dx, oy + dy, oz + dz);
                    BlockState state = world.getBlockState((BlockPos)pos);
                    if (state.isAir()) continue;
                    Block block = state.getBlock();
                    if (!state.is(BlockTags.BEE_GROWABLES) || !(block instanceof BonemealableBlock) || !(fertilizable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)world, (BlockPos)pos, state) || !fertilizable.isBonemealSuccess(world, rand, (BlockPos)pos, state)) continue;
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        fertilizable.performBonemeal(serverWorld, rand, (BlockPos)pos, state);
                        break block0;
                    }
                    BoneMealItem.addGrowthParticles((LevelAccessor)world, (BlockPos)pos, (int)15);
                    break block0;
                }
            }
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity firstPassenger = this.getFirstPassenger();
        if (firstPassenger instanceof Mob) {
            Mob mobEntity = (Mob)firstPassenger;
            return mobEntity;
        }
        if (this.getIsSaddled() && (firstPassenger = this.getFirstPassenger()) instanceof Player) {
            return (Player)firstPassenger;
        }
        return null;
    }

    private void setRiding(Player pPlayer) {
        pPlayer.setYRot(this.getYRot());
        pPlayer.setXRot(this.getXRot());
        pPlayer.startRiding((Entity)this);
    }

    public void travel(Vec3 movementInput) {
        if (this.isVehicle() && this.getControllingPassenger() instanceof Player) {
            LivingEntity livingentity = this.getControllingPassenger();
            this.setYRot(livingentity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(livingentity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            float f = livingentity.xxa * 0.5f;
            float f1 = livingentity.zza;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            if (this.isControlledByLocalInstance()) {
                float newSpeed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
                boolean sprinting = Minecraft.getInstance().options.keySprint.isDown();
                if (sprinting) {
                    newSpeed *= 1.4f;
                }
                this.setIsSprinting(sprinting);
                this.setSpeed(newSpeed);
                super.travel(new Vec3((double)f, movementInput.y, (double)f1));
            }
        } else {
            super.travel(movementInput);
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(passenger);
        }
        int[][] is = DismountHelper.offsetsForDirection((Direction)direction);
        BlockPos blockPos = this.blockPosition();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Pose entityPose : passenger.getDismountPoses()) {
            AABB box = passenger.getLocalBoundsForPose(entityPose);
            for (int[] js : is) {
                mutable.set(blockPos.getX() + js[0], blockPos.getY(), blockPos.getZ() + js[1]);
                double d = this.level().getBlockFloorHeight((BlockPos)mutable);
                if (!DismountHelper.isBlockFloorValid((double)d)) continue;
                Vec3 vec3d = Vec3.upFromBottomCenterOf((Vec3i)mutable, (double)d);
                if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)box.move(vec3d))) continue;
                passenger.setPose(entityPose);
                return vec3d;
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }
}

