/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.block.ModBlocks;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ButterflyPlaceCocoonGoal
extends MoveToBlockGoal {
    ButterflyEntity butterfly;

    public ButterflyPlaceCocoonGoal(ButterflyEntity butterfly, double speed) {
        super((PathfinderMob)butterfly, speed, 16);
        this.butterfly = butterfly;
    }

    public boolean canUse() {
        return this.butterfly.hasCocoon() && super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.butterfly.hasCocoon();
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            Level world = this.butterfly.level();
            BlockPos cocoonPos = this.blockPos;
            world.setBlock(cocoonPos, ((Block)ModBlocks.BUTTERFLY_COCOON.get()).defaultBlockState(), 3);
            this.butterfly.setHasCocoon(false);
        }
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        Block block = world.getBlockState(pos.above()).getBlock();
        BlockState state = world.getBlockState(pos.above());
        return !(!world.isEmptyBlock(pos) && !world.getBlockState(pos).canBeReplaced() || !(block instanceof LeavesBlock) && !state.is(BlockTags.LOGS) && !state.is(BlockTags.WART_BLOCKS) && !state.is(Blocks.BONE_BLOCK));
    }
}

