/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class ButterflyWanderNetherGoal
extends Goal {
    ButterflyEntity butterfly;

    public ButterflyWanderNetherGoal(ButterflyEntity butterfly) {
        this.butterfly = butterfly;
    }

    private static BlockPos getRandomPos(BlockPos center) {
        int x = center.getX() + (int)(Math.random() * 24.0 * 2.0) - 24;
        int y = center.getY() + (int)(Math.random() * 8.0 * 2.0) - 8;
        int z = center.getZ() + (int)(Math.random() * 24.0 * 2.0) - 24;
        return new BlockPos(x, y, z);
    }

    public boolean canUse() {
        return !this.butterfly.level().dimensionTypeRegistration().is(BuiltinDimensionTypes.OVERWORLD) && this.butterfly.getNavigation().isDone() && this.butterfly.getRandom().nextInt(3) == 0;
    }

    public boolean canContinueToUse() {
        return this.butterfly.getNavigation().isInProgress();
    }

    public void start() {
        BlockPos butterflyBlockPos = this.butterfly.blockPosition();
        BlockPos randomPos = ButterflyWanderNetherGoal.getRandomPos(butterflyBlockPos);
        if (this.butterfly.level().getBlockState(randomPos).canBeReplaced()) {
            this.butterfly.getNavigation().moveTo((double)randomPos.getX(), (double)randomPos.getY(), (double)randomPos.getZ(), 1.0);
        }
    }
}

