/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.EmperorPenguinEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EmperorPenguinLayEggGoal
extends MoveToBlockGoal {
    EmperorPenguinEntity emperorPenguinEntity;
    BlockState eggState;

    public EmperorPenguinLayEggGoal(EmperorPenguinEntity emperorPenguinEntity, double speed, BlockState eggState) {
        super((PathfinderMob)emperorPenguinEntity, speed, 16);
        this.emperorPenguinEntity = emperorPenguinEntity;
        this.eggState = eggState;
    }

    public boolean canUse() {
        return this.emperorPenguinEntity.hasEgg() && super.canUse() && this.emperorPenguinEntity.getEggTimer() >= 400;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.emperorPenguinEntity.hasEgg() && this.emperorPenguinEntity.getEggTimer() >= 400;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            Level world = this.emperorPenguinEntity.level();
            world.setBlock(this.blockPos.above(), this.eggState, 3);
            world.gameEvent((Holder)GameEvent.BLOCK_PLACE, this.blockPos.above(), GameEvent.Context.of((Entity)this.emperorPenguinEntity, (BlockState)this.eggState));
            this.emperorPenguinEntity.setHasEgg(false);
            this.emperorPenguinEntity.setEggTimer(0);
        }
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return !(!world.isEmptyBlock(pos.above()) && !world.getBlockState(pos.above()).canBeReplaced() || !state.is(BlockTags.ICE) && !state.is(Blocks.SNOW_BLOCK) && !state.is(BlockTags.DIRT) || world.getFluidState(pos.above()).is((Fluid)Fluids.WATER));
    }
}

