/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EscapeWaterGoal
extends Goal {
    private final ParentAnimalEntity animalEntity;

    public EscapeWaterGoal(ParentAnimalEntity animalEntity) {
        this.animalEntity = animalEntity;
    }

    public boolean canUse() {
        return this.animalEntity.isInWater();
    }

    public boolean canContinueToUse() {
        return this.animalEntity.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 rotation = this.animalEntity.getViewVector(0.0f);
        Vec3 targetedPos = HoverRandomPos.getPos((PathfinderMob)this.animalEntity, (int)8, (int)4, (double)rotation.x, (double)rotation.z, (float)1.5707964f, (int)3, (int)1);
        if (targetedPos != null) {
            targetedPos = new Vec3(targetedPos.x, targetedPos.y + 4.0, targetedPos.z);
            BlockPos pos = BlockPos.containing((double)targetedPos.x, (double)targetedPos.y, (double)targetedPos.z);
            Path path = this.animalEntity.getNavigation().createPath(pos, 1);
            if (path != null) {
                this.animalEntity.getNavigation().moveTo(path, 2.0);
            }
        }
        super.start();
    }
}

