/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.List;
import net.emilsg.clutterbestiary.entity.custom.SeahorseEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class SeahorseFollowParentGoal
extends Goal {
    public static final int HORIZONTAL_CHECK_RANGE = 8;
    public static final int VERTICAL_CHECK_RANGE = 4;
    public static final int MIN_DISTANCE = 3;
    private final SeahorseEntity seahorse;
    private final double speed;
    @Nullable
    private SeahorseEntity parent;
    private int delay;

    public SeahorseFollowParentGoal(SeahorseEntity seahorse, double speed) {
        this.seahorse = seahorse;
        this.speed = speed;
    }

    public boolean canUse() {
        if (this.seahorse.getBreedingAge() >= 0) {
            return false;
        }
        List list = this.seahorse.level().getEntitiesOfClass(((Object)((Object)this.seahorse)).getClass(), this.seahorse.getBoundingBox().inflate(8.0, 4.0, 8.0));
        SeahorseEntity seahorseEntity = null;
        double d = Double.MAX_VALUE;
        for (SeahorseEntity seahorseEntity1 : list) {
            double e;
            if (seahorseEntity1.getBreedingAge() < 0 || (e = this.seahorse.distanceToSqr((Entity)seahorseEntity1)) > d) continue;
            d = e;
            seahorseEntity = seahorseEntity1;
        }
        if (seahorseEntity == null) {
            return false;
        }
        if (d < 9.0) {
            return false;
        }
        this.parent = seahorseEntity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.seahorse.getBreedingAge() >= 0) {
            return false;
        }
        if (!this.parent.isAlive()) {
            return false;
        }
        double d = this.seahorse.distanceToSqr((Entity)this.parent);
        return !(d < 9.0) && !(d > 256.0);
    }

    public void start() {
        this.delay = 0;
    }

    public void stop() {
        this.parent = null;
    }

    public void tick() {
        if (--this.delay <= 0) {
            this.delay = this.adjustedTickDelay(10);
            this.seahorse.getNavigation().moveTo((Entity)this.parent, this.speed);
        }
    }
}

