/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum MossbloomVariant {
    HORNED("horned", true),
    FLOWERING("flowering", false);

    private final String name;
    private final boolean shouldGlow;

    private MossbloomVariant(String name, boolean shouldGlow) {
        this.name = name;
        this.shouldGlow = shouldGlow;
    }

    public static MossbloomVariant fromId(String id) {
        return Arrays.stream(MossbloomVariant.values()).filter(v -> v.getId().equals(id)).findFirst().orElse(HORNED);
    }

    public static MossbloomVariant getRandom() {
        List<MossbloomVariant> variants = Arrays.stream(MossbloomVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    @Nullable
    public ResourceLocation getEmissiveTextureLocation() {
        if (this.getShouldGlow()) {
            return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/mossbloom/" + this.getName() + "_mossbloom_emissive.png"));
        }
        return null;
    }

    public String getId() {
        return "clutterbestiary:" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public boolean getShouldGlow() {
        return this.shouldGlow;
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/mossbloom/" + this.getName() + "_mossbloom.png"));
    }
}

